package com.testor.module.fives.model.dto;

import com.testor.module.fives.model.domain.TFivesStandard;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 5s标准验收管理 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-11 14:00:17
 */

@Data
@ApiModel(value = "TFivesStandard 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TFivesStandardParam extends TFivesStandard {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

}
