package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardLicenseAnalysisInfo;
import com.testor.module.hazard.model.dto.THazardLicenseAnalysisInfoParam;
import com.testor.module.hazard.model.dto.THazardLicenseAnalysisInfoDelParam;
import com.testor.module.hazard.service.THazardLicenseAnalysisInfoService;

/**
 * 危险作业-许可证信息-分析信息Controller
 *
 * @author testor-framework
 * @date 2024-12-31 17:57:56
 */
@RestController
@RequestMapping("/module/licenseAnalysisInfo")
@Api(value = "THazardLicenseAnalysisInfo", tags = "危险作业-许可证信息-分析信息")
@Slf4j
public class THazardLicenseAnalysisInfoController extends SuperController
{
    @Autowired
    private THazardLicenseAnalysisInfoService tHazardLicenseAnalysisInfoService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业-许可证信息-分析信息", notes = "Add THazardLicenseAnalysisInfo")
	@PostMapping(value = "/add")
	public BaseResponse<THazardLicenseAnalysisInfo>addEntity(@RequestBody THazardLicenseAnalysisInfo addRequest) {
		BaseResponse<THazardLicenseAnalysisInfo> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardLicenseAnalysisInfo data=BeanHelper.beanToBean(addRequest,  THazardLicenseAnalysisInfo.class);
			data.setId(id);
			boolean result= tHazardLicenseAnalysisInfoService.save(data);
			if(result){
                THazardLicenseAnalysisInfo newEntity = new THazardLicenseAnalysisInfo();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息-分析信息 ", notes = "Get THazardLicenseAnalysisInfo By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardLicenseAnalysisInfo> getById(String id){
		BaseResponse<THazardLicenseAnalysisInfo> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardLicenseAnalysisInfo data= tHazardLicenseAnalysisInfoService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业-许可证信息-分析信息 ", notes = "Update THazardLicenseAnalysisInfo By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardLicenseAnalysisInfo updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseAnalysisInfo data=BeanHelper.beanToBean(updateRequest, THazardLicenseAnalysisInfo.class);
			boolean result= tHazardLicenseAnalysisInfoService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业-许可证信息-分析信息 ", notes = "delete THazardLicenseAnalysisInfo By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardLicenseAnalysisInfoDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseAnalysisInfo data= new THazardLicenseAnalysisInfo();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardLicenseAnalysisInfoService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业-许可证信息-分析信息", notes = "delete THazardLicenseAnalysisInfo by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardLicenseAnalysisInfoDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardLicenseAnalysisInfo> tHazardLicenseAnalysisInfoList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardLicenseAnalysisInfo data= new THazardLicenseAnalysisInfo();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardLicenseAnalysisInfoList.add(data);
			}
			boolean result = tHazardLicenseAnalysisInfoService.updateBatchById(tHazardLicenseAnalysisInfoList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息-分析信息 分页列表", notes = "List THazardLicenseAnalysisInfo with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardLicenseAnalysisInfo>>listEntity(THazardLicenseAnalysisInfoParam param){
		BaseResponse<BaseResponseList<THazardLicenseAnalysisInfo>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardLicenseAnalysisInfo> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseAnalysisInfo> queryWrapper=this.createQuery(param);
		Page<THazardLicenseAnalysisInfo> resultList= tHazardLicenseAnalysisInfoService.page(resultPage,queryWrapper);
		BaseResponseList<THazardLicenseAnalysisInfo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息-分析信息 列表", notes = "List THazardLicenseAnalysisInfo all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardLicenseAnalysisInfo>>listAllEntity(THazardLicenseAnalysisInfoParam param){
		BaseResponse<BaseResponseList<THazardLicenseAnalysisInfo>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseAnalysisInfo> queryWrapper=this.createQuery(param);
		List<THazardLicenseAnalysisInfo> resultList=tHazardLicenseAnalysisInfoService.list(queryWrapper);
		BaseResponseList<THazardLicenseAnalysisInfo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardLicenseAnalysisInfo> createQuery(THazardLicenseAnalysisInfoParam queryParam){
		QueryWrapper<THazardLicenseAnalysisInfo> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getLicenseId())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.LICENSE_ID,queryParam.getLicenseId());
		}
		if(StringHelper.isNotEmpty(queryParam.getAnalysisProject())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.ANALYSIS_PROJECT,queryParam.getAnalysisProject());
		}
		if(StringHelper.isNotEmpty(queryParam.getMeasurementValue())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.MEASUREMENT_VALUE,queryParam.getMeasurementValue());
		}
		if(StringHelper.isNotEmpty(queryParam.getConclusion())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.CONCLUSION,queryParam.getConclusion());
		}
		if(StringHelper.isNotEmpty(queryParam.getTesterSignature())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.TESTER_SIGNATURE,queryParam.getTesterSignature());
		}
		if(StringHelper.isNotEmpty(queryParam.getMeasurementLocation())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.MEASUREMENT_LOCATION,queryParam.getMeasurementLocation());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getMeasurementTime())){
			queryWrapper.eq(THazardLicenseAnalysisInfo.MEASUREMENT_TIME,queryParam.getMeasurementTime());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardLicenseAnalysisInfo.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardLicenseAnalysisInfo.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardLicenseAnalysisInfo.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
