package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 安全条件确认明细对象 t_hazard_condition_confirmation_details
 * 
 * @author testor-framework
 * @date 2024-12-24 21:53:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_condition_confirmation_details")
@ApiModel(value = "THazardConditionConfirmationDetails对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardConditionConfirmationDetails extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 危险作业计划id
 */
  @ApiModelProperty(value = "危险作业计划id")

  @TableField("plan_id")
  private String planId;
  /**
   * 条件确认id
   */
  @ApiModelProperty(value = "条件确认id")

  @TableField("condition_confirmation_id")
  private String conditionConfirmationId;
/**
 * 要素
 */
  @ApiModelProperty(value = "要素")

  @TableField("element")
  private String element;
/**
 * 条件
 */
  @ApiModelProperty(value = "条件")

  @TableField("condition")
  private String condition;
/**
 * 确认结果 0=符合,1=不符合,2=不涉及
 */
  @ApiModelProperty(value = "确认结果 0=符合,1=不符合,2=不涉及")

  @TableField("result")
  private String result;

  /**
   * 排序
   */
  @ApiModelProperty(value = "排序" , example = "0")

  @TableField("sort")
  private Long sort;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String CONDITION_CONFIRMATION_ID ="condition_confirmation_id";
  public static final String ELEMENT ="element";
  public static final String CONDITION ="condition";
  public static final String RESULT ="result";


}
