package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险作业-交底信息明细对象 t_hazard_disclosure_details
 * 
 * @author testor-framework
 * @date 2024-12-28 19:52:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_disclosure_details")
@ApiModel(value = "THazardDisclosureDetails对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardDisclosureDetails extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 交底id
 */
  @ApiModelProperty(value = "交底id")

  @TableField("disclosure_id")
  private String disclosureId;
/**
 * 要素
 */
  @ApiModelProperty(value = "要素")

  @TableField("element")
  private String element;
/**
 * 交底内容
 */
  @ApiModelProperty(value = "交底内容")

  @TableField("content")
  private String content;
/**
 * 是否交底 1=交底,2=不涉及
 */
  @ApiModelProperty(value = "是否交底 1=交底,2=不涉及")

  @TableField("is_disclosure")
  private String isDisclosure;
/**
 * 排序
 */
  @ApiModelProperty(value = "排序" , example = "0")

  @TableField("sort")
  private Long sort;

  public static final String ID ="id";
  public static final String DISCLOSURE_ID ="disclosure_id";
  public static final String ELEMENT ="element";
  public static final String CONTENT ="content";
  public static final String IS_DISCLOSURE ="is_disclosure";
  public static final String SORT ="sort";


}
