package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险作业-许可证信息对象 t_hazard_license
 * 
 * @author testor-framework
 * @date 2024-12-31 17:24:34
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_license")
@ApiModel(value = "THazardLicense对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardLicense extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 危险作业计划id
 */
  @ApiModelProperty(value = "危险作业计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 作业类型
 */
  @ApiModelProperty(value = "作业类型")

  @TableField("work_type")
  private String workType;
/**
 * 特定作业
 */
  @ApiModelProperty(value = "特定作业")

  @TableField("specific_task")
  private String specificTask;
/**
 * 涉及其他危险作业
 */
  @ApiModelProperty(value = "涉及其他危险作业")

  @TableField("involves_other_hazardous_work")
  private String involvesOtherHazardousWork;
/**
 * 高处作业设备工具
 */
  @ApiModelProperty(value = "高处作业设备工具")

  @TableField("elevated_equipment_name")
  private String elevatedEquipmentName;
/**
 * 悬挂位置
 */
  @ApiModelProperty(value = "悬挂位置")

  @TableField("suspension_location")
  private String suspensionLocation;
/**
 * 作业风险
 */
  @ApiModelProperty(value = "作业风险")

  @TableField("work_risk")
  private String workRisk;
/**
 * 设施所属单位
 */
  @ApiModelProperty(value = "设施所属单位")

  @TableField("facility_unit")
  private String facilityUnit;
/**
 * 设施名称
 */
  @ApiModelProperty(value = "设施名称")

  @TableField("facility_name")
  private String facilityName;
/**
 * 空间原有介质
 */
  @ApiModelProperty(value = "空间原有介质")

  @TableField("original_medium")
  private String originalMedium;
/**
 * 主要危险因素
 */
  @ApiModelProperty(value = "主要危险因素")

  @TableField("primary_hazard_factors")
  private String primaryHazardFactors;

  @ApiModelProperty(value = "作业现场负责人签字")
  @TableField("work_site_responsible_signature")
  private String workSiteResponsibleSignature;

  @ApiModelProperty(value = "监护人签字")
  @TableField("guardian_signature")
  private String guardianSignature;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String WORK_TYPE ="work_type";
  public static final String SPECIFIC_TASK ="specific_task";
  public static final String INVOLVES_OTHER_HAZARDOUS_WORK ="involves_other_hazardous_work";
  public static final String ELEVATED_EQUIPMENT_NAME ="elevated_equipment_name";
  public static final String SUSPENSION_LOCATION ="suspension_location";
  public static final String WORK_RISK ="work_risk";
  public static final String FACILITY_UNIT ="facility_unit";
  public static final String FACILITY_NAME ="facility_name";
  public static final String ORIGINAL_MEDIUM ="original_medium";
  public static final String PRIMARY_HAZARD_FACTORS ="primary_hazard_factors";


}
