package com.testor.module.hazard.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.hazard.model.domain.THazardAssessment;
import com.testor.module.hazard.model.domain.THazardAssessmentDetails;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class THazardAssessmentDTO extends THazardAssessment {

    @ApiModelProperty(value = "作业单位")
    private String workUnitName;

    @ApiModelProperty(value = "作业内容")
    private String workContent;

    @ApiModelProperty(value = "作业开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduledStartTime;

    @ApiModelProperty(value = "作业结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduledEndTime;

    @ApiModelProperty(value = "作业地点")
    private String workLocation;

    @ApiModelProperty(value = "作业现场负责人")
    private String workSiteResponsibleName;

    @ApiModelProperty(value = "风险分析参与人")
    private String riskAnalysisParticipantName;

    List<THazardAssessmentDetails> tHazardAssessmentDetails;

}
