package com.testor.module.hazard.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum WorkTypeEnum {

    /**
     * 进出仓作业
     */
    ENTRY_EXIT_WAREHOUSE("1", "进出仓作业"),

    /**
     * 高处作业
     */
    HEIGHT_WORK("2", "高处作业"),

    /**
     * 动火作业
     */
    HOT_WORK("3", "动火作业"),

    /**
     * 有限空间作业
     */
    CONFINED_SPACE_WORK("4", "有限空间作业"),

    /**
     * 临时用电作业
     */
    TEMPORARY_ELECTRICITY_WORK("5", "临时用电作业"),

    /**
     * 吊装作业
     */
    LIFTING_WORK("6", "吊装作业"),

    /**
     * 动土作业
     */
    EARTHWORK("7", "动土作业"),

    /**
     * 断路作业
     */
    DISCONNECTION_WORK("8", "断路作业"),

    /**
     * 液氨接卸作业
     */
    AMMONIA_UNLOADING("9", "液氨接卸作业"),

    /**
     * 熏蒸作业
     */
    FUMIGATION_WORK("10", "熏蒸作业"),

    /**
     * 环流熏蒸作业
     */
    CIRCULATING_FUMIGATION("11", "环流熏蒸作业"),

    /**
     * 进仓
     */
    ENTRY_WAREHOUSE("12", "进仓"),

    /**
     * 出仓
     */
    EXIT_WAREHOUSE("13", "出仓"),

    /**
     * 平仓
     */
    CLOSE_POSITION("14", "平仓"),

    /**
     * 不涉及
     */
    NOT_INVOLVED("0", "不涉及");


    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static WorkTypeEnum fromValue(String value) {
        for (WorkTypeEnum workType : values()) {
            if (workType.value.equals(value)) {
                return workType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}
