package com.testor.module.hazard.scheduler.jobs;

import com.testor.module.hazard.service.TimeoutRemindStrategy;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class ReminderJob implements Job {

    @Autowired
    private Map<String, TimeoutRemindStrategy> strategyMap;

    /**
     * 执行调度任务
     * @param context
     * @throws JobExecutionException
     */
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String id = dataMap.getString("id");
        String remindType = dataMap.getString("remindType");
        TimeoutRemindStrategy strategy = strategyMap.get(remindType);
        if (strategy != null) {
            strategy.remind(id);
        } else {
            // 处理未定义的提醒类型
        }
    }
}