package com.testor.module.hazard.task;

import com.testor.common.core.utils.StringUtils;
import com.testor.common.util.SpringBeanFactory;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;

import java.util.Map;

public class LicenseCheckUsersListener implements TaskListener {

    private final THazardWorkPlanService tHazardWorkPlanService;
    public LicenseCheckUsersListener() {
        this.tHazardWorkPlanService = SpringBeanFactory.getBean(THazardWorkPlanService.class);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        Map<String, Object> variables = delegateTask.getVariables();
        System.out.println(variables);
        String bizId = delegateTask.getVariable("bizKeyId").toString();
        String submitter = delegateTask.getVariable("submitter").toString();
        String isReject = delegateTask.getVariable("rejected").toString();
        //审批通过
        if ("0".equals(isReject)) {
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null) {
                //修改审批人
                String licenseCheckUser = byId.getLicenseCheckUser();
                THazardWorkPlan tHazardWorkPlan = new THazardWorkPlan();
                tHazardWorkPlan.setId(bizId);
                if (StringUtils.isNotBlank(licenseCheckUser)) {
                    tHazardWorkPlan.setLicenseCheckUser(licenseCheckUser + "," + submitter);
                } else {
                    tHazardWorkPlan.setLicenseCheckUser(submitter);
                }
                tHazardWorkPlanService.updateById(tHazardWorkPlan);
            }
        }

    }


}
