package com.testor.module.hire.controller;

import com.alibaba.fastjson.JSON;
import com.testor.module.hire.entity.vo.HireDepositoryDetailVo;
import com.testor.module.hire.entity.vo.HireDepositoryListVo;
import com.testor.module.hire.service.DepositoryManageBaseService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * <p>
 * 租赁库管理-客商基本信息 前端控制器
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
@Api(value = "hireDepositoryManageBase", tags = "租赁库管理-客商基本信息")
@RestController
@RequestMapping("/hireDepositoryManageBase")
@Slf4j
public class DepositoryManageBaseController {
    @Autowired
    private DepositoryManageBaseService depositoryManageBaseService;


    @ApiOperation(value = "租赁库列表", notes = "分页列表查询")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<HireDepositoryListVo>> findList(HireDepositoryListVo vo) {
        BaseResponseList<HireDepositoryListVo> hireDepositoryList = depositoryManageBaseService.findHireDepositoryList(vo);
        BaseResponse<BaseResponseList<HireDepositoryListVo>> baseResponse = new BaseResponse<>();
        baseResponse.setData(hireDepositoryList);
        return baseResponse;
    }

    @ApiOperation(value = "租赁库详情", notes = "租赁库详情")
    @GetMapping(value = "/detail")
    public BaseResponse<HireDepositoryDetailVo> findDetail(String id) {
        HireDepositoryDetailVo hireDepositoryDetail = depositoryManageBaseService.findHireDepositoryDetail(id,null);
        BaseResponse<HireDepositoryDetailVo> baseResponse = new BaseResponse<>();
        baseResponse.setData(hireDepositoryDetail);
        return baseResponse;
    }

    @ApiOperation(value = "租赁库设置", notes = "租赁库所属单位设置详情")
    @GetMapping(value = "/updateHireOrgCode")
    public BaseResponse<Boolean> updateHireOrgCode(String id, String orgCode) {
        depositoryManageBaseService.updateHireDepositoryOrgCode(id, orgCode);
        BaseResponse<Boolean> baseResponse = new BaseResponse<>();
        baseResponse.setData(Boolean.TRUE);
        return baseResponse;
    }


    @ApiOperation(value = "租赁库数据更新", notes = "租赁库数据更新")
    @PostMapping(value = "/pushData")
    public BaseResponse<HireDepositoryDetailVo> pushData(@RequestBody HireDepositoryDetailVo vo) {
        log.info("中粮租赁库推送数据，pushData:{}", JSON.toJSONString(vo));
        try {
            return depositoryManageBaseService.saveHireDepositoryInfo(vo);
        } catch (Exception e) {
            log.error("中粮租赁库推送数据，保存失败，pushData:{}", JSON.toJSONString(vo), e);
            BaseResponse<HireDepositoryDetailVo> baseResponse = new BaseResponse<>();
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("数据更新失败");
            return baseResponse;
        }
    }


    @ApiOperation(value = "中粮附件下载接口", notes = "中粮附件下载接口")
    @GetMapping(value = "/zlFileLoad")
    public void zlFileLoad(String processCode, String id, String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        depositoryManageBaseService.dowonLoadFile(processCode, id, fileName, response);
    }


    @ApiOperation(value = "历史数据导入", notes = "历史数据导入")
    @PostMapping(value = "/historicalDataImport")
    public BaseResponse<String> historicalDataImport(@RequestParam("file") MultipartFile file) throws IOException {
        return depositoryManageBaseService.historicalDataImport(file);
    }




}



