package com.testor.module.iam.controller;

import com.testor.biz.auth.model.TokenResponse;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.iam.model.domain.IamDepartment;
import com.testor.module.iam.model.domain.IamSysUser;
import com.testor.module.iam.model.dto.BindIamUserDto;
import com.testor.module.iam.model.dto.IamDepartmentQueryDto;
import com.testor.module.iam.model.dto.IamLoginDto;
import com.testor.module.iam.model.dto.IamUserQueryDto;
import com.testor.module.iam.service.IamSysUserService;
import com.testor.module.iam.service.IamUserMappingService;
import com.testor.module.iam.util.RequestIamUtil;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * @ClassName: IamUserController
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2023/12/29 14:57
 * @Version: 1.0
 */

@RestController
@RequestMapping("/iam/user")
@Api(value = "IamUser", tags = "IAM用户操作")
@Slf4j
public class IamUserController {


    @Autowired
    private IamUserMappingService iamUserMappingService;

    @Autowired
    private IamSysUserService iamSysUserService;

    @Autowired
    private RequestIamUtil requestIamUtil;

    @ApiOperation(
            value = "绑定IAM用户",
            notes = "绑定IAM用户"
    )
    @PostMapping({"/bindIamUser"})
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<TokenResponse> bindIamUser(@Valid @RequestBody BindIamUserDto bindIamUserDto) {
        return iamUserMappingService.bindIamUserAndLogin(bindIamUserDto);
    }

    @ApiOperation(
            value = "获取用户绑定列表",
            notes = "获取用户绑定列表"
    )
    @PostMapping({"/getBindUserList"})
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<SysUser>> getBindUserList(@Valid @RequestBody IamLoginDto iamLoginDto){
        return iamSysUserService.getBindUserList(iamLoginDto);
    }


    @ApiOperation(
            value = "获取token",
            notes = "获取token"
    )
    @PostMapping({"/getToken"})
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<TokenResponse> getToken(@Valid @RequestBody IamLoginDto iamLoginDto){
        return iamSysUserService.getToken(iamLoginDto);
    }

    @ApiOperation(
            value = "获取IAM部门",
            notes = "获取IAM部门"
    )
    @PostMapping({"/getDepartmentList"})
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<IamDepartment>> getDepartmentList(IamDepartmentQueryDto dto){
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData(requestIamUtil.getDepartmentList(dto));
        return baseResponse;
    }

    @ApiOperation(
            value = "获取IAM用户信息",
            notes = "获取IAM用户信息"
    )
    @PostMapping({"/getUser"})
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<IamSysUser>> getUser(IamUserQueryDto queryDto){
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData(requestIamUtil.getUser(queryDto));
        return baseResponse;
    }
}
