package com.testor.module.iam.service;

import com.testor.biz.auth.model.TokenResponse;
import com.testor.module.iam.model.domain.IamUserMapping;
import com.testor.module.iam.model.dto.BindIamUserDto;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * @ClassName: IamUserMappingService
 * @Description: IAM用户映射
 * @Author: lm
 * @CreateTime: 2023/12/29 10:15
 * @Version: 1.0
 */
public interface IamUserMappingService extends SuperService<IamUserMapping> {

    /**
     * 绑定IAM用户并执行登录
     * @param bindUserDto
     * @return
     */
    BaseResponse<TokenResponse> bindIamUserAndLogin(BindIamUserDto bindUserDto);

    /**
     * 绑定iam账户与系统账户
     * @param userId
     * @param iamUserId
     * @return
     */
    boolean bindIamUser(String userId,String iamUserId);

    IamUserMapping getByUserId(String userId);

    List<IamUserMapping> getByIamUserId(String iamUserId);

    /**
     * 通过userId删除映射关系
     * @param userId
     * @return
     */
    boolean deleteByUserId(String userId);

    boolean deleteByIamUserId(String iamUserId);

}
