package com.testor.module.mq.dao;

import com.testor.module.mq.domain.WeatherDomain;
import com.testor.module.mq.vo.WeatherWarnInfoVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTaskSqlParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface WeatherDao extends SuperDao<WeatherDomain> {
    List<WeatherWarnInfoVO> getInfoByList(@Param("list") List<String> codeList);

    String selectDirct(@Param("code") String code);

    /**
     * 组织机构人员总数
     */
    Integer numberOfUsers(@Param("orgId")String orgId);

    /**
     * 值班日志数量
     */
    Integer dutyLogQuantity(@Param("orgId")String orgId);

    /**
     * 危险源数量
     */
    Integer numberOfRiskSources(@Param("orgId")String orgId);

    /**
     * 风险点数量
     */
    Integer numberOfRiskPoints(@Param("orgId")String orgId);

    /**
     * 隐患数量
     */
    Integer theNumberOfHiddenLedger(@Param("orgId")String orgId);

    /**
     * 设备监控数量
     */
    Integer numberOfMonitoringDevices(@Param("orgId")String orgId);


    /**
     * 报警总数
     */
    Integer totalAlarm(@Param("orgId")String orgId);

    /**
     * 危险作业次数
     */
    Integer numberOfHazardousOperations(@Param("orgId")String orgId);


    /**
     * 相关方数量
     */
    Integer numberOfInterestedParties(@Param("orgId")String orgId);

    /**
     * 相关方人数
     *
     * @return
     */
    Integer numberOfRelevantPartyPersonnel(@Param("orgId")String orgId);

    /**
     * 应急预案数量
     *
     * @return
     */
    Integer numberOfEmergencyPlans(@Param("orgId")String orgId);

    /**
     * 员工培训数量
     *
     * @return
     */
    Integer numberOfStaffTraining(@Param("orgId")String orgId);

    /**
     * 三同时数量
     *
     * @return
     */
    Integer trisimultaneousQuantity(@Param("orgId")String orgId);

    /**
     * 节能环保月报上传数量
     *
     * @return
     */
    Integer energyConservationQuantity(@Param("orgId")String orgId);

    /**
     * 亮点数量
     *
     * @return
     */
    Integer numberOfBrightSpots(@Param("orgId")String orgId);

    /**
     * 事故数量
     *
     * @return
     */
    Integer numberOfAccidents(@Param("orgId")String orgId);

    /**
     * 公告数量
     *
     * @return
     */
    Integer quantityOfAnnouncement(@Param("orgId")String orgId);

    /**
     * 新闻数量
     *
     * @return
     */
    Integer newsQuantity(@Param("orgId")String orgId);

    /**
     * 租赁库数量
     *
     * @return
     */
    Integer numberOfRentalWarehouses(@Param("orgId")String orgId);

    /**
     * 设备台账录入数量
     *
     * @return
     */
    Integer equipmentLedgerEntryQuantity(@Param("orgId")String orgId);

    /**
     * 空间台账录入数量
     *
     * @return
     */
    Integer spaceLedgerEntryQuantity(@Param("orgId")String orgId);

    Integer selectToDoList( @Param("todo") TodoTaskSqlParam todoTaskSqlParam);

}
