package com.testor.module.partner.controller;

import com.testor.module.partner.model.dto.TJobAccountingDTO;
import com.testor.module.partner.model.vo.TJobAccountingVO;
import com.testor.module.partner.service.TJobAccountingService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * 现场作业_作业统计分析Controller
 *
 * @author testor-framework
 * @date 2022-07-07 14:35:54
 */
@RestController
@RequestMapping("/module/accounting")
@Api(value = "TJobAccounting", tags = "现场作业_作业统计分析")
@Slf4j
public class TJobAccountingController extends SuperController {
    @Autowired
    private TJobAccountingService tJobAccountingService;

    @ApiOperation(value = "获取 现场作业_作业统计分析 危险作业次数")
    @GetMapping("/getAttTypeCount")
    public BaseResponse<TJobAccountingVO> getAttTypeCount(TJobAccountingDTO tJobAccountingDTO) {
        return tJobAccountingService.getAttTypeCount(tJobAccountingDTO);
    }

    @ApiOperation(value = "导入 现场作业_作业统计分析 ")
    @GetMapping("importAccounting")
    public BaseResponse<String> importAccounting(@RequestParam("file") MultipartFile file) {
        return tJobAccountingService.importAccounting(file);
    }



}
