package com.testor.module.safeCheck.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;

import java.math.BigDecimal;


/**
 * 安全检查计划和被检查机构关系对象 t_safe_check_org
 * 
 * @author rsq
 * @date 2024-09-03 08:04:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_org")
@ApiModel(value = "TSafeCheckOrg对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckOrg extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 安全巡检计划id
 */
  @ApiModelProperty(value = "安全巡检计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 被检查机构id
 */
  @ApiModelProperty(value = "被检查机构id")

  @TableField("check_org_id")
  private String checkOrgId;

  /**
   * 被检查机构id
   */
  @ApiModelProperty(value = "被检查机构名称")
  @TableField(exist = false)
  private String checkOrgName;

  /**
   * 被检查机构层级
   */
  @ApiModelProperty(value = "被检查机构层级")
  @TableField(exist = false)
  private BigDecimal treeLevel;

  /**
   * 被检查机构性质
   */
  @ApiModelProperty(value = "被检查机构性质")
  @TableField(exist = false)
  private String nature;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String CHECK_ORG_ID ="check_org_id";


}
