package com.testor.module.safeCheck.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPeople;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 巡检计划对象 t_safe_hazard_check_plan
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
@Data
public class TSafeHazardCheckPlanDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 排查单位id
 */
  @ApiModelProperty(value = "排查单位id(编辑必填)")
  private String orgId;
/**
 * 被排查单位id
 */
  @ApiModelProperty(value = "被排查单位id(编辑必填)")
  private String checkedOrgId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")
  private String code;
/**
 * 计划开始时间
 */
  @ApiModelProperty(value = "计划开始时间(编辑必填)")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;
/**
 * 计划结束时间
 */
  @ApiModelProperty(value = "计划结束时间(编辑必填)")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;
/**
 * 是否双休日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否双休日(0-不包含，跳过；1-包含，不跳过)(编辑必填)")
  private String inWeekend;
/**
 * 是否跳过节假日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否跳过节假日(0-不包含，跳过；1-包含，不跳过)(编辑必填)")
  private String inHoliday;
/**
 * 提前小时
 */
  @ApiModelProperty(value = "提前小时(编辑必填)" , example = "0")
  private Long advanceHour;

  @ApiModelProperty(value = "被排查单位层级id")
  private String checkedOrgParentIds;

  @ApiModelProperty(value = "排查对象(编辑必填)")
  private List<TSafeHazardCheckObject> checkObjectList;

  @ApiModelProperty(value = "排查人员(编辑必填)")
  private List<TSafeHazardCheckPeople> checkPeopleList;


}
