package com.testor.module.safeCheck.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.util.CheckResultStatusEnum;
import com.testor.module.safeCheck.dao.TSafeHazardCheckResultDao;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckResult;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckResultParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultDetailCountVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultVO;
import com.testor.module.safeCheck.service.TSafeHazardCheckObjectService;
import com.testor.module.safeCheck.service.TSafeHazardCheckResultDetailService;
import com.testor.module.safeCheck.service.TSafeHazardCheckResultService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 巡检结果Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:54
 */
@Slf4j
@Service
public class TSafeHazardCheckResultServiceImpl extends SuperServiceImpl<TSafeHazardCheckResultDao, TSafeHazardCheckResult> implements TSafeHazardCheckResultService
{
    @Autowired(required = false)
    private TSafeHazardCheckResultDao tSafeHazardCheckResultDao;

    @Resource
    private TSafeHazardCheckResultDetailService checkResultDetailService;

    @Resource
    private TSafeHazardCheckObjectService tSafeHazardCheckObjectService;

    public Boolean createByTask(String taskId, String planId) {
        if(StrUtil.isBlank(taskId) || StrUtil.isBlank(planId)) {
            log.error("创建巡检结果 参数缺失 taskId:{}, planId:{}", taskId, planId);
            return false;
        }

        List<TSafeHazardCheckObject> checkObjectList = tSafeHazardCheckObjectService.listByPlan(planId);
        if(checkObjectList == null || checkObjectList.size() ==0) {
            log.error("创建巡检计划时未设置检查对象 planId:{}", planId);
            return false;
        }

        List<TSafeHazardCheckResult> addList = new ArrayList<>();
        TSafeHazardCheckResult checkResult;
        // key - checkobjId ; value - standardId
        Map<String, String> objectMap = new HashMap<>();
        for(TSafeHazardCheckObject checkObject : checkObjectList) {
            String checkObjId = checkObject.getId();
            checkResult = new TSafeHazardCheckResult();
            checkResult.setTaskId(taskId);
            checkResult.setCheckObjId(checkObjId);
            checkResult.setResultStatus(CheckResultStatusEnum.nostart.getCode());
            addList.add(checkResult);

            objectMap.put(checkObjId, checkObject.getStandardId());
        }

        Boolean saveResult = saveBatch(addList, addList.size());
        if(!saveResult) {
            return false;
        }

        Boolean detailResult = true;
        for(TSafeHazardCheckResult item : addList) {
            detailResult = checkResultDetailService.createResultDetail(item.getId(), objectMap.get(item.getCheckObjId()));
            if(!detailResult) {
              //  throw new RuntimeException("巡检结果明细创建失败");
                return detailResult;
            }
        }

        return true;
    }

    public List<SafeHazardCheckResultVO> listByTask(String taskId){
        List<SafeHazardCheckResultVO> resultVOList = tSafeHazardCheckResultDao.listByTask(taskId);
        if(resultVOList == null || resultVOList.size() == 0) {
            return null;
        }

        for(SafeHazardCheckResultVO result : resultVOList) {
            List<SafeHazardCheckResultDetailCountVO> detailCountVOList = checkResultDetailService.countByResult(result.getId());
            result.setCheckResultDetailCountList(detailCountVOList);
        }
        return resultVOList;
    }

    public List<TSafeHazardCheckResult> listEntity(TSafeHazardCheckResultParam param) {
        QueryWrapper<TSafeHazardCheckResult> queryWrapper=this.createQuery(param);
        List<TSafeHazardCheckResult> resultList= list(queryWrapper);
        return resultList;
    }

    private QueryWrapper<TSafeHazardCheckResult> createQuery(TSafeHazardCheckResultParam queryParam){
        QueryWrapper<TSafeHazardCheckResult> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getCheckObjId())){
            queryWrapper.eq(TSafeHazardCheckResult.CHECK_OBJ_ID,queryParam.getCheckObjId());
        }
        if(StringHelper.isNotEmpty(queryParam.getTaskId())){
            queryWrapper.eq(TSafeHazardCheckResult.TASK_ID,queryParam.getTaskId());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getResultStatus())){
            queryWrapper.eq(TSafeHazardCheckResult.RESULT_STATUS,queryParam.getResultStatus());
        }
        if(queryParam.getResultStatusList() != null && queryParam.getResultStatusList().size() > 0) {
            queryWrapper.in(TSafeHazardCheckResult.RESULT_STATUS,queryParam.getResultStatusList());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeHazardCheckResult.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeHazardCheckResult.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeHazardCheckResult.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
