package com.testor.module.train.project.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 评价管理端——安全培训教育对象 t_train_evaluate_manage
 * 
 * @author testor-framework
 * @date 2022-08-13 14:16:27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_evaluate_manage")
@ApiModel(value = "TTrainEvaluateManage对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainEvaluateManage extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 说明
 */
  @ApiModelProperty(value = "说明")

  @TableField("statement")
  private String statement;
/**
 * 评估类型
 */
  @ApiModelProperty(value = "评估  1 评估类型  2 评估内容")

  @TableField("assess_state")
  private String assessState;
/**
 * 评估内容
 */
  @ApiModelProperty(value = "评估内容")

  @TableField("assess_content")
  private String assessContent;
/**
 * 评分
 */
  @ApiModelProperty(value = "评分")

  @TableField("assess_minute")
  private String assessMinute;
  /**
 * 评分
 */
  @ApiModelProperty(value = "评分详情")
  @TableField(exist = false)
  private String assessMinuteInfo;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 机构ID
 */
  @ApiModelProperty(value = "机构ID")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String STATEMENT ="statement";
  public static final String ASSESS_TYPE ="assess_type";
  public static final String ASSESS_CONTENT ="assess_content";
  public static final String ASSESS_MINUTE ="assess_minute";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String ORG_ID ="org_id";


}
