package com.testor.module.wf.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import com.tongtech.tfw.workflow.apis.task.model.domain.ActRuTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface RuTaskDao extends SuperDao<ActRuTask> {

    HisTask getHisTask(@Param("his") HisTaskListRequest his);

    List<Map> countToDo(@Param("userId") String userId, @Param("orgId") String orgId);

    IPage<TodoTask> selectToDoList(IPage<TodoTask> page, @Param("todo") TodoTaskSqlParam todoTaskSqlParam);

    IPage<HisTask> selectHisTaskList(IPage<HisTask> page, @Param("his") HisTaskSqlParam hisTaskSqlParam);

    /**
     * 删除运行变量（异常）
     */
    int deleteRuVariableException();

    /**
     * 删除历史变量（异常）
     */
    int deleteHiVariableException();
}
