package com.testor.module.wf.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.wf.vo.ProcessDefListRequestVO;
import com.testor.module.wf.vo.ZlmyProcessInsListRequest;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.workflow.apis.definition.model.domain.ActReProcdef;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefListRequest;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefListResponse;
import com.tongtech.tfw.workflow.apis.task.model.dto.*;

import java.util.List;
import java.util.Map;

public interface RuTaskService {
    HisTask getHisTask(HisTaskListRequest hisTaskListRequest);

    BaseResponseList<ProcessDefListResponse> getProcessDefList(ProcessDefListRequestVO param);

    List<Map> countToDo(String userId, String orgId);

    IPage<TodoTask> selectToDoList(IPage<TodoTask> page, TodoTaskSqlParam todoTaskSqlParam);

    IPage<HisTask> selectHisTaskList(IPage<HisTask> page, HisTaskSqlParam hisTaskSqlParam);

    /**
     * 获取el表达式的值
     * @param exp el表达式
     * @param variableMap map参数
     * @return true/false
     */
    boolean getElValue(String exp, Map<String, Object> variableMap);

    /**
     * 获取el表达式的值
     * @param processInstanceId 流程实例id
     * @param exp el表达式
     * @param variableMap map参数
     * @return true/false
     */
    boolean getElValue(String processInstanceId, String exp, Map<String, Object> variableMap);

    /**
     * 根据参数，预测、获取下一任务节点集合
     *
     * @param taskId 任务id
     * @param variables 参数
     * @return 下一任务节点集合
     */
    List<String> getNextNameTasks(String taskId, Map<String, Object> variables);

}
