package com.testor.workflow.task.service.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.workflow.task.model.dto.TaskCompleteParamsChild;
import com.testor.workflow.task.service.ZTfwTaskService;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.constants.TfwServiceConstants;
import com.tongtech.tfw.workflow.constants.TfwWorkFlowConstants;
import com.tongtech.tfw.workflow.service.TfwTaskService;
import com.tongtech.tfw.workflow.service.dto.TaskCompleteParams;
import com.tongtech.tfw.workflow.service.dto.TaskServiceResult;
import io.jsonwebtoken.lang.Collections;
import org.flowable.engine.TaskService;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * TfwTaskServiceImpl
 *
 * @author Created by ivan on 2020/8/26 .
 * @version 1.0
 */
@Service
public class ZTfwTaskServiceImpl implements ZTfwTaskService {
  @Autowired private TaskService taskService;

  @Autowired
  private TfwTaskService tfwTaskService;

  @Override
  public TaskServiceResult completeTask(TaskCompleteParamsChild taskCompleteParams) {
    if (ObjectHelper.isEmpty(taskCompleteParams) || taskCompleteParams.checkMiss()) {
      return TaskServiceResult.builder()
          .code(TfwServiceConstants.TASK_COMPLETE_MISS_ID)
          .result(TaskCompleteParams.check(taskCompleteParams))
          .build();
    }
    // Set Variables
    if (ObjectHelper.isEmpty(taskCompleteParams.getVars())
        || Collections.isEmpty(taskCompleteParams.getVars())) {
      taskCompleteParams.setVars(new HashMap<>());
    }
    taskCompleteParams.getVars().put(TfwWorkFlowConstants.EXECUTOR, taskCompleteParams.getUserId());
    taskCompleteParams
        .getVars()
        .put(TfwWorkFlowConstants.EXECUTOR_ORG_ID, taskCompleteParams.getOrgId());
    taskCompleteParams
        .getVars()
        .put(TfwWorkFlowConstants.BIZ_PRIMARY_KEY, taskCompleteParams.getBizId());
    // Complete Task
    Task task;
    String taskId;
    if(!StrUtil.isBlank(taskCompleteParams.getTaskId())) {
       taskId = taskCompleteParams.getTaskId();
      task = tfwTaskService.getRuTask(taskId);
    } else {
      task = taskService.createTaskQuery()
              .processInstanceId(taskCompleteParams.getProcessInstanceId())
              .taskAssignee(taskCompleteParams.getUserId())
              .singleResult();
      taskId = task.getId();
    }

    // Delegation Task
    if (ObjectHelper.isNotEmpty(task.getDelegationState())
        && DelegationState.PENDING == task.getDelegationState()) {
      addComments(taskId, taskCompleteParams.getComment());
      taskService.setVariablesLocal(taskId, taskCompleteParams.getVars());
      taskService.resolveTask(taskId, taskCompleteParams.getVars());
      return TaskServiceResult.builder()
          .code(TfwServiceConstants.TASK_COMPLETE_RESOLVE)
          .result(taskId)
          .build();
    } else {
      addComments(taskId, taskCompleteParams.getComment());
      taskService.setVariablesLocal(taskId, taskCompleteParams.getVars());
      taskService.complete(taskId, new HashMap<>(), taskCompleteParams.getVars());
      return TaskServiceResult.builder()
          .code(TfwServiceConstants.TASK_COMPLETE_SUCCESS)
          .result(taskId)
          .build();
    }
  }

  private void addComments(String taskId, String comment) {
    if (StringHelper.isBlank(taskId) || StringHelper.isBlank(comment)) {
    } else {
      taskService.addComment(taskId, null, null, comment);
    }
  }
}
