package com.testor.module.train.project.service;

import com.alibaba.fastjson.JSON;
import com.testor.StartupApplication;
import com.testor.module.train.project.model.stat.ProjectStatTotalVo;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT, classes = StartupApplication.class)
class TrainProjectStatisticsAllServiceTest {

    @Autowired private TrainProjectStatisticsAllService trainProjectStatisticsAllService;



    @Test
    void testFindOrgId() {
        String orgId = "1a8cb532e9bf404db6e1b0c03a71696d";
        ProjectStatTotalVo projectNum = trainProjectStatisticsAllService
                .findProjectNumTotal(orgId, "2024-09-01 00:00:00", "2024-09-30 23:59:59",null);
        System.out.println(JSON.toJSONString(projectNum));
    }

    @Test
    void findProjectNumByOrgOrVisitType() {
        UserInfo loginUser = new UserInfo();
        loginUser.setOrgId("1a8cb532e9bf404db6e1b0c03a71696d");
        //String orgId = "1a8cb532e9bf404db6e1b0c03a71696d";

        String startTime = "2024-09-01 00:00:00";
        String endTime = "2024-09-30 23:59:59";
        String type = "1";
        System.out.println(JSON.toJSONString( trainProjectStatisticsAllService.findProjectNumByOrgOrVisitType(null, startTime, endTime, type)));

    }


    @Test
    void findTrainTimeByOrgOrVisitType() {
        String orgId = "32cdbb3a278944f1a83ca40dbcc93c0a";
        String startTime = "2024-09-01 00:00:00";
        String endTime = "2024-09-30 00:00:00";
        String type = "1";
        List<ProjectStatTotalVo> projectNumByOrgOrVisitType = trainProjectStatisticsAllService.findTrainTimeByOrgOrVisitType(orgId, startTime, endTime, type);
        System.out.println(JSON.toJSONString(projectNumByOrgOrVisitType));

    }



    @Test
    void findPersonNumByOrgOrVisitType() {
        String orgId = "363920a37d6343be8735addbba817900";
        String startTime = "2024-09-01 00:00:00";
        String endTime = "2024-09-30 00:00:00";
        String type = "1";

        System.out.println(JSON.toJSONString( trainProjectStatisticsAllService.findPersonNumByOrgOrVisitType(orgId, startTime, endTime, type)));

    }



}