/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.Context;
import com.tongweb.container.WebResourceRoot;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class TongWebEmbedResources {
    private final Context context;

    protected abstract void addJar(String var1);

    protected abstract void addDir(String var1, URL var2);

    public void addClasspathResources() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                String dir;
                String file = url.getFile();
                if (file.endsWith(".jar") || file.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addJar(jar);
                    continue;
                }
                if (!url.toString().startsWith("file:") || !new File(dir = url.toString().substring("file:".length())).isDirectory()) continue;
                this.addDir(dir, url);
            }
        }
    }

    protected final Context getContext() {
        return this.context;
    }

    public static TongWebEmbedResources get(Context context) {
        return new TongWebResources(context);
    }

    TongWebEmbedResources(Context context) {
        this.context = context;
    }

    static class TongWebResources
    extends TongWebEmbedResources {
        TongWebResources(Context context) {
            super(context);
        }

        @Override
        protected void addJar(String jar) {
            this.addResourceSet(jar);
        }

        @Override
        protected void addDir(String dir, URL url) {
            this.addResourceSet(url.toString());
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.getContext().getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }
}

