/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.Context;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.TrackedWebResource;
import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.webresources.DirResourceSet;
import com.tongweb.container.webresources.EmptyResourceSet;
import com.tongweb.container.webresources.FileResourceSet;
import com.tongweb.container.webresources.JarResourceSet;
import com.tongweb.container.webresources.JarWarResourceSet;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.container.webresources.TongWebURLStreamHandlerFactory;
import com.tongweb.container.webresources.WarResourceSet;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.starter.TongWebEmbedCache;
import com.tongweb.web.util.buf.UriUtil;
import com.tongweb.web.util.compat.JreCompat;
import com.tongweb.web.util.http.RequestUtil;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class TongWebEmbedStandardRoot
extends StandardRoot {
    private static final Log log = LogFactory.getLog(TongWebEmbedStandardRoot.class);
    protected static final StringManager sm = StringManager.getManager(StandardRoot.class);
    private Context context;
    private boolean allowLinking = false;
    private final List<WebResourceSet> preResources = new ArrayList<WebResourceSet>();
    private WebResourceSet main;
    private final List<WebResourceSet> classResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> jarResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> postResources = new ArrayList<WebResourceSet>();
    private final TongWebEmbedCache cache = new TongWebEmbedCache(this);
    private boolean cachingAllowed = true;
    private ObjectName cacheJmxName = null;
    private boolean trackLockedFiles = false;
    private final Set<TrackedWebResource> trackedResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<WebResourceSet> mainResources = new ArrayList<WebResourceSet>();
    private final List<List<WebResourceSet>> allResources = new ArrayList<List<WebResourceSet>>();

    public TongWebEmbedStandardRoot() {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
    }

    public TongWebEmbedStandardRoot(Context context) {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
        this.context = context;
    }

    public String[] list(String path) {
        return this.list(path, true);
    }

    private String[] list(String path, boolean validate) {
        if (validate) {
            path = this.validate(path);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                String[] entries = webResourceSet.list(path);
                result.addAll(Arrays.asList(entries));
            }
        }
        return result.toArray(new String[0]);
    }

    public Set<String> listWebAppPaths(String path) {
        path = this.validate(path);
        HashSet<String> result = new HashSet<String>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                result.addAll(webResourceSet.listWebAppPaths(path));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public boolean mkdir(String path) {
        if (this.preResourceExists(path = this.validate(path))) {
            return false;
        }
        boolean mkdirResult = this.main.mkdir(path);
        if (mkdirResult && this.isCachingAllowed()) {
            this.cache.removeCacheEntry(path);
        }
        return mkdirResult;
    }

    public boolean write(String path, InputStream is, boolean overwrite) {
        path = this.validate(path);
        if (!overwrite && this.preResourceExists(path)) {
            return false;
        }
        boolean writeResult = this.main.write(path, is, overwrite);
        if (writeResult && this.isCachingAllowed()) {
            this.cache.removeCacheEntry(path);
        }
        return writeResult;
    }

    private boolean preResourceExists(String path) {
        for (WebResourceSet webResourceSet : this.preResources) {
            WebResource webResource = webResourceSet.getResource(path);
            if (!webResource.exists()) continue;
            return true;
        }
        return false;
    }

    public WebResource getResource(String path) {
        return this.getResource(path, true, false);
    }

    protected WebResource getResource(String path, boolean validate, boolean useClassLoaderResources) {
        if (validate) {
            path = this.validate(path);
        }
        if (this.isCachingAllowed()) {
            return this.cache.getResource(path, useClassLoaderResources);
        }
        return this.getResourceInternal(path, useClassLoaderResources);
    }

    public WebResource getClassLoaderResource(String path) {
        return this.getResource("/WEB-INF/classes" + path, true, true);
    }

    public WebResource[] getClassLoaderResources(String path) {
        return this.getResources("/WEB-INF/classes" + path, true);
    }

    private String validate(String path) {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardRoot.checkStateNotStarted"));
        }
        if (path == null || path.length() == 0 || !path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPath", new Object[]{path}));
        }
        String result = File.separatorChar == '\\' ? RequestUtil.normalize((String)path, (boolean)true) : RequestUtil.normalize((String)path, (boolean)false);
        if (result == null || result.length() == 0 || !result.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPathNormal", new Object[]{path, result}));
        }
        return result;
    }

    public WebResource getTongWebResourceInternal(String path, boolean useClassLoaderResources) {
        WebResource result = null;
        WebResource virtual = null;
        WebResource mainEmpty = null;
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if ((useClassLoaderResources || webResourceSet.getClassLoaderOnly()) && (!useClassLoaderResources || webResourceSet.getStaticOnly())) continue;
                result = webResourceSet.getResource(path);
                if (result.exists()) {
                    return result;
                }
                if (virtual != null) continue;
                if (result.isVirtual()) {
                    virtual = result;
                    continue;
                }
                if (!this.main.equals(webResourceSet)) continue;
                mainEmpty = result;
            }
        }
        if (virtual != null) {
            return virtual;
        }
        return mainEmpty;
    }

    public WebResource[] getResources(String path) {
        return this.getResources(path, false);
    }

    private WebResource[] getResources(String path, boolean useClassLoaderResources) {
        path = this.validate(path);
        if (this.isCachingAllowed()) {
            return this.cache.getResources(path, useClassLoaderResources);
        }
        return this.getResourcesInternal(path, useClassLoaderResources);
    }

    protected WebResource[] getResourcesInternal(String path, boolean useClassLoaderResources) {
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                WebResource webResource;
                if (!useClassLoaderResources && webResourceSet.getClassLoaderOnly() || !(webResource = webResourceSet.getResource(path)).exists()) continue;
                result.add(webResource);
            }
        }
        if (result.size() == 0) {
            result.add(this.main.getResource(path));
        }
        return result.toArray(new WebResource[0]);
    }

    public WebResource[] listResources(String path) {
        return this.listResources(path, true);
    }

    protected WebResource[] listResources(String path, boolean validate) {
        if (validate) {
            path = this.validate(path);
        }
        String[] resources = this.list(path, false);
        WebResource[] result = new WebResource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            result[i] = path.charAt(path.length() - 1) == '/' ? this.getResource(path + resources[i], false, false) : this.getResource(path + '/' + resources[i], false, false);
        }
        return result;
    }

    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, URL url, String internalPath) {
        BaseLocation baseLocation = new BaseLocation(url);
        this.createWebResourceSet(type, webAppMount, baseLocation.getBasePath(), baseLocation.getArchivePath(), internalPath);
    }

    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, String base, String archivePath, String internalPath) {
        Object resourceSet;
        List<WebResourceSet> resourceList;
        switch (type) {
            case PRE: {
                resourceList = this.preResources;
                break;
            }
            case CLASSES_JAR: {
                resourceList = this.classResources;
                break;
            }
            case RESOURCE_JAR: {
                resourceList = this.jarResources;
                break;
            }
            case POST: {
                resourceList = this.postResources;
                break;
            }
            default: {
                throw new IllegalArgumentException(sm.getString("standardRoot.createUnknownType", new Object[]{type}));
            }
        }
        File file = new File(base);
        if (file.isFile()) {
            resourceSet = archivePath != null ? new JarWarResourceSet((WebResourceRoot)this, webAppMount, base, archivePath, internalPath) : (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") ? new JarResourceSet((WebResourceRoot)this, webAppMount, base, internalPath) : new FileResourceSet((WebResourceRoot)this, webAppMount, base, internalPath));
        } else if (file.isDirectory()) {
            resourceSet = new DirResourceSet((WebResourceRoot)this, webAppMount, base, internalPath);
        } else {
            throw new IllegalArgumentException(sm.getString("standardRoot.createInvalidFile", new Object[]{file}));
        }
        if (type.equals((Object)WebResourceRoot.ResourceSetType.CLASSES_JAR)) {
            resourceSet.setClassLoaderOnly(true);
        } else if (type.equals((Object)WebResourceRoot.ResourceSetType.RESOURCE_JAR)) {
            resourceSet.setStaticOnly(true);
        }
        resourceList.add((WebResourceSet)resourceSet);
    }

    public void addPreResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot((WebResourceRoot)this);
        this.preResources.add(webResourceSet);
    }

    public WebResourceSet[] getPreResources() {
        return this.preResources.toArray(new WebResourceSet[0]);
    }

    public void addJarResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot((WebResourceRoot)this);
        this.jarResources.add(webResourceSet);
    }

    public WebResourceSet[] getJarResources() {
        return this.jarResources.toArray(new WebResourceSet[0]);
    }

    public void addPostResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot((WebResourceRoot)this);
        this.postResources.add(webResourceSet);
    }

    public WebResourceSet[] getPostResources() {
        return this.postResources.toArray(new WebResourceSet[0]);
    }

    protected WebResourceSet[] getClassResources() {
        return this.classResources.toArray(new WebResourceSet[0]);
    }

    protected void addClassResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot((WebResourceRoot)this);
        this.classResources.add(webResourceSet);
    }

    public void setAllowLinking(boolean allowLinking) {
        if (this.allowLinking != allowLinking && this.cachingAllowed) {
            this.cache.clear();
        }
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
        if (!cachingAllowed) {
            this.cache.clear();
        }
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public WebResourceRoot.CacheStrategy getCacheStrategy() {
        return this.cache.getCacheStrategy();
    }

    public void setCacheStrategy(WebResourceRoot.CacheStrategy strategy) {
        this.cache.setCacheStrategy(strategy);
    }

    public long getCacheTtl() {
        return this.cache.getTtl();
    }

    public void setCacheTtl(long cacheTtl) {
        this.cache.setTtl(cacheTtl);
    }

    public long getCacheMaxSize() {
        return this.cache.getMaxSize();
    }

    public void setCacheMaxSize(long cacheMaxSize) {
        this.cache.setMaxSize(cacheMaxSize);
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cache.setObjectMaxSize(cacheObjectMaxSize);
        if (this.getState().isAvailable()) {
            this.cache.enforceObjectMaxSizeLimit();
        }
    }

    public int getCacheObjectMaxSize() {
        return this.cache.getObjectMaxSize();
    }

    public void setTrackLockedFiles(boolean trackLockedFiles) {
        this.trackLockedFiles = trackLockedFiles;
        if (!trackLockedFiles) {
            this.trackedResources.clear();
        }
    }

    public boolean getTrackLockedFiles() {
        return this.trackLockedFiles;
    }

    public List<String> getTrackedResources() {
        ArrayList<String> result = new ArrayList<String>(this.trackedResources.size());
        for (TrackedWebResource resource : this.trackedResources) {
            result.add(resource.toString());
        }
        return result;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected void processWebInfLib() throws LifecycleException {
        WebResource[] possibleJars;
        for (WebResource possibleJar : possibleJars = this.listResources("/WEB-INF/lib", false)) {
            if (!possibleJar.isFile() || !possibleJar.getName().endsWith(".jar")) continue;
            this.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", possibleJar.getURL(), "/");
        }
    }

    public void backgroundProcess() {
        this.cache.backgroundProcess();
        this.gc();
    }

    public void gc() {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.gc();
            }
        }
    }

    public void registerTrackedResource(TrackedWebResource trackedResource) {
        this.trackedResources.add(trackedResource);
    }

    public void deregisterTrackedResource(TrackedWebResource trackedResource) {
        this.trackedResources.remove(trackedResource);
    }

    public List<URL> getBaseUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                URL url;
                if (webResourceSet.getClassLoaderOnly() || (url = webResourceSet.getBaseUrl()) == null) continue;
                result.add(url);
            }
        }
        return result;
    }

    protected boolean isPackedWarFile() {
        return this.main instanceof WarResourceSet && this.preResources.isEmpty() && this.postResources.isEmpty();
    }

    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    protected String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=WebResourceRoot");
        keyProperties.append(this.context.getMBeanKeyProperties());
        return keyProperties.toString();
    }

    protected void initInternal() throws LifecycleException {
        if (this.context == null) {
            throw new IllegalStateException(sm.getString("standardRoot.noContext"));
        }
        this.cacheJmxName = this.register((Object)this.cache, this.getObjectNameKeyProperties() + ",name=Cache");
        this.registerURLStreamHandlerFactory();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.init();
            }
        }
    }

    protected void registerURLStreamHandlerFactory() {
        if (!JreCompat.isGraalAvailable()) {
            TongWebURLStreamHandlerFactory.register();
        }
    }

    protected void startInternal() throws LifecycleException {
        this.mainResources.clear();
        this.main = this.createMainResourceSet();
        this.mainResources.add(this.main);
        for (List<WebResourceSet> list : this.allResources) {
            if (list == this.classResources) continue;
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.start();
            }
        }
        this.processWebInfLib();
        for (WebResourceSet classResource : this.classResources) {
            classResource.start();
        }
        this.cache.enforceObjectMaxSizeLimit();
        this.setState(LifecycleState.STARTING);
    }

    protected WebResourceSet createMainResourceSet() {
        EmptyResourceSet mainResourceSet;
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            mainResourceSet = new EmptyResourceSet((WebResourceRoot)this);
        } else {
            File f = new File(docBase);
            if (!f.isAbsolute()) {
                f = new File(((Host)this.context.getParent()).getAppBaseFile(), f.getPath());
            }
            if (f.isDirectory()) {
                mainResourceSet = new DirResourceSet((WebResourceRoot)this, "/", f.getAbsolutePath(), "/");
            } else if (f.isFile() && docBase.endsWith(".war")) {
                mainResourceSet = new WarResourceSet((WebResourceRoot)this, "/", f.getAbsolutePath());
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.startInvalidMain", new Object[]{f.getAbsolutePath()}));
            }
        }
        return mainResourceSet;
    }

    protected void stopInternal() throws LifecycleException {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.stop();
            }
        }
        if (this.main != null) {
            this.main.destroy();
        }
        this.mainResources.clear();
        for (WebResourceSet webResourceSet : this.jarResources) {
            webResourceSet.destroy();
        }
        this.jarResources.clear();
        for (WebResourceSet webResourceSet : this.classResources) {
            webResourceSet.destroy();
        }
        this.classResources.clear();
        for (TrackedWebResource trackedResource : this.trackedResources) {
            log.error((Object)sm.getString("standardRoot.lockedFile", new Object[]{this.context.getName(), trackedResource.getName()}), (Throwable)trackedResource.getCreatedBy());
            try {
                trackedResource.close();
            }
            catch (IOException iOException) {}
        }
        this.cache.clear();
        this.setState(LifecycleState.STOPPING);
    }

    protected void destroyInternal() throws LifecycleException {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.destroy();
            }
        }
        this.unregister(this.cacheJmxName);
    }

    public TongWebEmbedCache getCache() {
        return this.cache;
    }

    static class BaseLocation {
        private final String basePath;
        private final String archivePath;

        BaseLocation(URL url) {
            File f = null;
            if ("jar".equals(url.getProtocol()) || "war".equals(url.getProtocol())) {
                String jarUrl = url.toString();
                int endOfFileUrl = -1;
                endOfFileUrl = "jar".equals(url.getProtocol()) ? jarUrl.indexOf("!/") : jarUrl.indexOf(UriUtil.getWarSeparator());
                String fileUrl = jarUrl.substring(4, endOfFileUrl);
                try {
                    f = new File(new URL(fileUrl).toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                int startOfArchivePath = endOfFileUrl + 2;
                this.archivePath = jarUrl.length() > startOfArchivePath ? jarUrl.substring(startOfArchivePath) : null;
            } else if ("file".equals(url.getProtocol())) {
                try {
                    f = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                this.archivePath = null;
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.unsupportedProtocol", new Object[]{url.getProtocol()}));
            }
            this.basePath = f.getAbsolutePath();
        }

        String getBasePath() {
            return this.basePath;
        }

        String getArchivePath() {
            return this.archivePath;
        }
    }
}

