/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.Context;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.descriptor.web.ContextEnvironment;
import com.tongweb.web.util.res.StringManager;

public class ContextNamingInfoListener
implements LifecycleListener {
    private static final String PATH_ENTRY_NAME = "context/path";
    private static final String ENCODED_PATH_ENTRY_NAME = "context/encodedPath";
    private static final String WEBAPP_VERSION_ENTRY_NAME = "context/webappVersion";
    private static final String NAME_ENTRY_NAME = "context/name";
    private static final String BASE_NAME_ENTRY_NAME = "context/baseName";
    private static final String DISPLAY_NAME_ENTRY_NAME = "context/displayName";
    private static final Log log = LogFactory.getLog(ContextNamingInfoListener.class);
    private static final StringManager sm = StringManager.getManager(ContextNamingInfoListener.class);
    private boolean emptyOnRoot = true;

    public void setEmptyOnRoot(boolean emptyOnRoot) {
        this.emptyOnRoot = emptyOnRoot;
    }

    public boolean isEmptyOnRoot() {
        return this.emptyOnRoot;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("configure_start")) {
            if (!(event.getLifecycle() instanceof Context)) {
                log.warn(sm.getString("listener.notContext", event.getLifecycle().getClass().getSimpleName()));
                return;
            }
            Context context = (Context)event.getLifecycle();
            String path = context.getPath();
            String encodedPath = context.getEncodedPath();
            String name = context.getName();
            if (!this.emptyOnRoot && path.isEmpty()) {
                encodedPath = "/";
                path = "/";
                name = "ROOT" + name;
            }
            this.addEnvEntry(context, PATH_ENTRY_NAME, path);
            this.addEnvEntry(context, ENCODED_PATH_ENTRY_NAME, encodedPath);
            this.addEnvEntry(context, WEBAPP_VERSION_ENTRY_NAME, context.getWebappVersion());
            this.addEnvEntry(context, NAME_ENTRY_NAME, name);
            this.addEnvEntry(context, BASE_NAME_ENTRY_NAME, context.getBaseName());
            this.addEnvEntry(context, DISPLAY_NAME_ENTRY_NAME, context.getDisplayName());
        }
    }

    private void addEnvEntry(Context context, String name, String value) {
        ContextEnvironment ce = new ContextEnvironment();
        ce.setName(name);
        ce.setOverride(true);
        ce.setType("java.lang.String");
        ce.setValue(value);
        if (log.isDebugEnabled()) {
            log.info(sm.getString("contextNamingInfoListener.envEntry", name, value));
        }
        context.getNamingResources().addEnvironment(ce);
    }
}

