/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.sanyuan;

import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.role.model.domain.SysRole;
import com.testor.biz.sys.role.model.dto.SysRoleCreateAndUpdateRequest;
import com.testor.biz.sys.role.service.SysRoleService;
import com.testor.biz.sys.sanyuan.model.domain.SysSanyuan;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.model.dto.SysUserCreateAndUpdateRequest;
import com.testor.biz.sys.user.model.dto.SysUserRoleRequest;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.context.ContextHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanYuanMsgFormatter {
    private static final Logger log = LoggerFactory.getLogger(SanYuanMsgFormatter.class);

    public static String msgFormatter(SysSanyuan sysSanyuan) {
        String message = "";
        if (ObjectHelper.isNotEmpty((Object)((Object)sysSanyuan))) {
            switch (sysSanyuan.getSyOpType()) {
                case "user": {
                    message = SanYuanMsgFormatter.userMsg(sysSanyuan);
                    break;
                }
                case "role": {
                    message = SanYuanMsgFormatter.roleMsg(sysSanyuan);
                    break;
                }
                case "auth": {
                    message = SanYuanMsgFormatter.authMsg(sysSanyuan);
                    break;
                }
                default: {
                    message = sysSanyuan.getSyOpData();
                }
            }
        }
        return message;
    }

    private static String userMsg(SysSanyuan sysSanyuan) {
        StringBuilder message = new StringBuilder();
        SysUserCreateAndUpdateRequest sysUserCreateAndUpdateRequest = (SysUserCreateAndUpdateRequest)JacksonHelper.readValue((String)sysSanyuan.getSyOpData(), SysUserCreateAndUpdateRequest.class);
        SysUserService sysUserService = (SysUserService)ContextHelper.getBeanByType(SysUserService.class);
        SysOrgService sysOrgService = (SysOrgService)ContextHelper.getBeanByType(SysOrgService.class);
        message.append("\u7528\u6237\u767b\u5f55\u540d: ");
        if (StringHelper.isNotBlank((CharSequence)sysUserCreateAndUpdateRequest.getUserId())) {
            SysUser sysUser = (SysUser)((Object)sysUserService.getById((Serializable)((Object)sysUserCreateAndUpdateRequest.getUserId())));
            message.append(sysUser.getLoginName()).append("; \u7528\u6237\u59d3\u540d: ").append(sysUser.getUserName()).append("; \u6240\u5c5e\u90e8\u95e8: ").append(sysOrgService.getOrgFullPathName(sysUser.getOrgId()));
        } else {
            message.append(sysUserCreateAndUpdateRequest.getLoginName()).append("; \u7528\u6237\u59d3\u540d: ").append(sysUserCreateAndUpdateRequest.getUserName()).append("; \u6240\u5c5e\u90e8\u95e8: ").append(sysOrgService.getOrgFullPathName(sysUserCreateAndUpdateRequest.getOrgId()));
        }
        return message.toString();
    }

    private static String roleMsg(SysSanyuan sysSanyuan) {
        StringBuilder message = new StringBuilder();
        SysRoleService sysRoleService = (SysRoleService)ContextHelper.getBeanByType(SysRoleService.class);
        SysRoleCreateAndUpdateRequest sysRoleCreateAndUpdateRequest = (SysRoleCreateAndUpdateRequest)JacksonHelper.readValue((String)sysSanyuan.getSyOpData(), SysRoleCreateAndUpdateRequest.class);
        message.append("\u89d2\u8272\u540d\u79f0: ");
        if (StringHelper.isNotBlank((CharSequence)sysRoleCreateAndUpdateRequest.getRoleId())) {
            SysRole sysRole = (SysRole)((Object)sysRoleService.getById((Serializable)((Object)sysRoleCreateAndUpdateRequest.getRoleId())));
            message.append(sysRole.getRoleName()).append("; \u89d2\u8272\u7f16\u7801: ").append(sysRole.getRoleCode());
        } else {
            message.append(sysRoleCreateAndUpdateRequest.getRoleName()).append("; \u89d2\u8272\u7f16\u7801: ").append(sysRoleCreateAndUpdateRequest.getRoleCode());
        }
        return message.toString();
    }

    private static String authMsg(SysSanyuan sysSanyuan) {
        StringBuilder message = new StringBuilder();
        SysUserRoleRequest sysUserRoleRequest = (SysUserRoleRequest)JacksonHelper.readValue((String)sysSanyuan.getSyOpData(), SysUserRoleRequest.class);
        SysUserService sysUserService = (SysUserService)ContextHelper.getBeanByType(SysUserService.class);
        SysRoleService sysRoleService = (SysRoleService)ContextHelper.getBeanByType(SysRoleService.class);
        message.append("\u7528\u6237\u540d\u79f0: ").append(((SysUser)((Object)sysUserService.getById((Serializable)((Object)sysUserRoleRequest.getUserId())))).getUserName());
        String[] roles = sysUserRoleRequest.getRoleId();
        message.append("; \u5173\u8054\u89d2\u8272: ");
        for (String role : roles) {
            message.append(((SysRole)((Object)sysRoleService.getById((Serializable)((Object)role)))).getRoleName()).append(";");
        }
        return message.toString();
    }
}

