/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.util;

import com.testor.biz.sys.dict.data.model.dto.SysDicDTO;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CacheDicUtils {
    private static final Logger log = LoggerFactory.getLogger(CacheDicUtils.class);
    private static Map<String, String> dataMap = new HashMap<String, String>();
    @Autowired
    private SysDictDataService sysDictDataService;

    @PostConstruct
    public void init() {
        List<SysDicDTO> sysDicList = this.sysDictDataService.selectBusinessDic();
        for (SysDicDTO obj : sysDicList) {
            try {
                dataMap.put(obj.getDictTypeKey() + obj.getDictKey(), obj.getDictValue());
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u5b57\u6bb5\u6570\u636e\u5931\u8d25:e={},object={}", (Object)obj);
            }
        }
    }

    public static String get(String type, String key) {
        String name = dataMap.get(type + key);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        return "";
    }

    public static String getByKeys(String type, String keys, String regex) {
        if (StringUtils.isBlank((CharSequence)keys)) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)regex)) {
            regex = ",";
        }
        String[] split = keys.split(regex);
        return Arrays.asList(split).stream().map(key -> {
            String name = dataMap.get(type + key);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return name;
            }
            return key;
        }).collect(Collectors.joining("/"));
    }

    public static void set(String type, String key, String value) {
        dataMap.put(type + key, value);
    }

    public static void remove(String type, String key) {
        dataMap.remove(type + key);
    }
}

