package com.testor.config;


import com.testor.common.annotation.ExcelSelectedType;
import com.testor.common.excel.select.ExcelDynamicSelect;
import com.testor.common.util.excel.EasyExcelUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 下拉框数据配置类
 *
 * @author Lion Li
 */
@Slf4j
@Configuration
public class ExcelSelectConfig {


    @Autowired
    private List<ExcelDynamicSelect<?>> list;

    @PostConstruct
    public void init() {
        Map<String, ExcelDynamicSelect<?>> map = new HashMap<>(list.size());
        for (ExcelDynamicSelect<?> trans : list) {
            if (trans.getClass().isAnnotationPresent(ExcelSelectedType.class)) {
                ExcelSelectedType annotation = trans.getClass().getAnnotation(ExcelSelectedType.class);
                map.put(annotation.type(), trans);
            } else {
                log.warn(trans.getClass().getName() + " 翻译实现类未标注 TranslationType 注解!");
            }
        }
        EasyExcelUtil.EXCEL_SELECT_MAPPER.putAll(map);
    }


}
