package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.common.constant.StatusEnum;
import com.testor.common.util.BeanConverUtil;
import com.testor.module.contractor.enums.DailyPlanContentEnum;
import com.testor.module.contractor.enums.DailyPlanStatusEnum;
import com.testor.module.contractor.enums.DailyPlanStopRestartWorkEnum;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanChange;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanContent;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanStopRestartWork;
import com.testor.module.contractor.manage.model.dto.TContractorAllowParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanDTO;
import com.testor.module.contractor.manage.service.TContractorDailyPlanChangeService;
import com.testor.module.contractor.manage.service.TContractorDailyPlanContentService;
import com.testor.module.contractor.manage.service.TContractorDailyPlanStopRestartWorkService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlan;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanService;

/**
 * 日常管理-每日工作计划Controller
 *
 * @author testor-framework
 * @date 2024-11-28 15:21:05
 */
@RestController
@RequestMapping("/manage/plan")
@Api(value = "TContractorDailyPlan", tags = "日常管理-每日工作计划")
@Slf4j
public class TContractorDailyPlanController extends SuperController
{
    @Autowired
    private TContractorDailyPlanService tContractorDailyPlanService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划", notes = "Add TContractorDailyPlan")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlan>addEntity(@RequestBody TContractorDailyPlanDTO addRequest) {
		BaseResponse<TContractorDailyPlan> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			TContractorDailyPlan tContractorDailyPlan= tContractorDailyPlanService.addEntity(addRequest);
			baseResponse.setData(tContractorDailyPlan);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划 ", notes = "Get TContractorDailyPlan By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlan> getById(String id){
		BaseResponse<TContractorDailyPlan> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			TContractorDailyPlanDTO tContractorDailyPlanDTO = tContractorDailyPlanService.getDetails(id);
			baseResponse.setData(tContractorDailyPlanDTO);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划 ", notes = "Update TContractorDailyPlan By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlan updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlan data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlan.class);
			boolean result= tContractorDailyPlanService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划 ", notes = "delete TContractorDailyPlan By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlan data= new TContractorDailyPlan();
			data.setId(deleteRequest.getId());
			data.setStatus(StatusEnum.DELETE.getCode());
			boolean result= tContractorDailyPlanService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划", notes = "delete TContractorDailyPlan by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlan> tContractorDailyPlanList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlan data= new TContractorDailyPlan();
				data.setId(id);
				data.setStatus(StatusEnum.DELETE.getCode());
                tContractorDailyPlanList.add(data);
			}
			boolean result = tContractorDailyPlanService.updateBatchById(tContractorDailyPlanList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "提交", notes = "启动流程")
	@PostMapping(value = "/submit")
	public BaseResponse<BizGeneralResponse> submit(@RequestBody TContractorDailyPlanDTO tContractorDailyPlanDTO){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(tContractorDailyPlanDTO)&&StringHelper.isNotEmpty(tContractorDailyPlanDTO.getId())){
			tContractorDailyPlanService.submit(tContractorDailyPlanDTO);
		}
		return baseResponse;
	}

	@ApiOperation(value = "完成流程", notes = "完成流程 通过/驳回")
	@PostMapping(value = "/completeProcess")
	public BaseResponse<BizGeneralResponse> completeProcess(@RequestBody TContractorDailyPlanDTO tContractorDailyPlanDTO){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(tContractorDailyPlanDTO)&&StringHelper.isNotEmpty(tContractorDailyPlanDTO.getId())){
			tContractorDailyPlanService.completeProcess(tContractorDailyPlanDTO);
		}
		return baseResponse;
	}



	@ApiOperation(value = "获取 日常管理-每日工作计划 分页列表", notes = "List TContractorDailyPlan with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanDTO>>listEntity(TContractorDailyPlanParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanDTO>>baseResponse=new BaseResponse<>();
		param.setOrgId(ContextUtils.getLoginUser().getOrgId());
		Page<TContractorDailyPlanDTO> resultList= tContractorDailyPlanService.listEntity(param);
		BaseResponseList<TContractorDailyPlanDTO> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划 列表", notes = "List TContractorDailyPlan all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlan>>listAllEntity(TContractorDailyPlanParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlan>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlan> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlan> resultList=tContractorDailyPlanService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlan> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlan> createQuery(TContractorDailyPlanParam queryParam){
		QueryWrapper<TContractorDailyPlan> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorDailyPlan.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjId())){
			queryWrapper.eq(TContractorDailyPlan.PROJ_ID,queryParam.getProjId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorDailyPlan.BIZ_ID,queryParam.getBizId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessId())){
			queryWrapper.eq(TContractorDailyPlan.PROCESS_ID,queryParam.getProcessId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessStatus())){
			queryWrapper.eq(TContractorDailyPlan.PROCESS_STATUS,queryParam.getProcessStatus());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkSite())){
			queryWrapper.eq(TContractorDailyPlan.WORK_SITE,queryParam.getWorkSite());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkContent())){
			queryWrapper.eq(TContractorDailyPlan.WORK_CONTENT,queryParam.getWorkContent());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getWorkStartTime())){
			queryWrapper.eq(TContractorDailyPlan.WORK_START_TIME,queryParam.getWorkStartTime());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getWorkFinishTime())){
			queryWrapper.eq(TContractorDailyPlan.WORK_FINISH_TIME,queryParam.getWorkFinishTime());
		}
		if(StringHelper.isNotEmpty(queryParam.getSpecialPeriod())){
			queryWrapper.eq(TContractorDailyPlan.SPECIAL_PERIOD,queryParam.getSpecialPeriod());
		}
		if(StringHelper.isNotEmpty(queryParam.getSiteManager())){
			queryWrapper.eq(TContractorDailyPlan.SITE_MANAGER,queryParam.getSiteManager());
		}
		if(StringHelper.isNotEmpty(queryParam.getTel())){
			queryWrapper.eq(TContractorDailyPlan.TEL,queryParam.getTel());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getWorkPersNum())){
			queryWrapper.eq(TContractorDailyPlan.WORK_PERS_NUM,queryParam.getWorkPersNum());
		}
		if(StringHelper.isNotEmpty(queryParam.getDepartmentId())){
			queryWrapper.eq(TContractorDailyPlan.DEPARTMENT_ID,queryParam.getDepartmentId());
		}
		if(StringHelper.isNotEmpty(queryParam.getChangeProcessStatus())){
			queryWrapper.eq(TContractorDailyPlan.CHANGE_STATUS,queryParam.getChangeProcessStatus());
		}
		if(StringHelper.isNotEmpty(queryParam.getStopStartProcessStatus())){
			queryWrapper.eq(TContractorDailyPlan.STOP_START_STATUS,queryParam.getStopStartProcessStatus());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlan.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlan.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlan.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
