package com.testor.module.contractor.manage.controller;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanInspectResult;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanInspectResultParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanInspectResultDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanInspectResultService;

/**
 * 日常管理-每日工作计划-检查任务-检查结果Controller
 *
 * @author testor-framework
 * @date 2024-11-30 15:43:17
 */
@RestController
@RequestMapping("/manage/result")
@Api(value = "TContractorDailyPlanInspectResult", tags = "日常管理-每日工作计划-检查任务-检查结果")
@Slf4j
public class TContractorDailyPlanInspectResultController extends SuperController
{
    @Autowired
    private TContractorDailyPlanInspectResultService tContractorDailyPlanInspectResultService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划-检查任务-检查结果", notes = "Add TContractorDailyPlanInspectResult")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanInspectResult>addEntity(@RequestBody TContractorDailyPlanInspectResult addRequest) {
		BaseResponse<TContractorDailyPlanInspectResult> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanInspectResult data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanInspectResult.class);
			data.setId(id);
			boolean result= tContractorDailyPlanInspectResultService.save(data);
			if(result){
                TContractorDailyPlanInspectResult newEntity = new TContractorDailyPlanInspectResult();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查任务-检查结果 ", notes = "Get TContractorDailyPlanInspectResult By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanInspectResult> getById(String id){
		BaseResponse<TContractorDailyPlanInspectResult> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanInspectResult data= tContractorDailyPlanInspectResultService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划-检查任务-检查结果 ", notes = "Update TContractorDailyPlanInspectResult By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanInspectResult updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanInspectResult data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanInspectResult.class);
			boolean result= tContractorDailyPlanInspectResultService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划-检查任务-检查结果 ", notes = "delete TContractorDailyPlanInspectResult By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanInspectResultDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanInspectResult data= new TContractorDailyPlanInspectResult();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanInspectResultService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划-检查任务-检查结果", notes = "delete TContractorDailyPlanInspectResult by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanInspectResultDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanInspectResult> tContractorDailyPlanInspectResultList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanInspectResult data= new TContractorDailyPlanInspectResult();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanInspectResultList.add(data);
			}
			boolean result = tContractorDailyPlanInspectResultService.updateBatchById(tContractorDailyPlanInspectResultList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查任务-检查结果 分页列表", notes = "List TContractorDailyPlanInspectResult with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanInspectResult>>listEntity(TContractorDailyPlanInspectResultParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanInspectResult>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanInspectResult> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanInspectResult> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanInspectResult> resultList= tContractorDailyPlanInspectResultService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanInspectResult> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查任务-检查结果 列表", notes = "List TContractorDailyPlanInspectResult all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanInspectResult>>listAllEntity(TContractorDailyPlanInspectResultParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanInspectResult>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanInspectResult> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanInspectResult> resultList=tContractorDailyPlanInspectResultService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanInspectResult> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanInspectResult> createQuery(TContractorDailyPlanInspectResultParam queryParam){
		QueryWrapper<TContractorDailyPlanInspectResult> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getInspectId())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.INSPECT_ID,queryParam.getInspectId());
		}
		if(StringHelper.isNotEmpty(queryParam.getType())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.TYPE,queryParam.getType());
		}
		if(StringHelper.isNotEmpty(queryParam.getInspectItem())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.INSPECT_ITEM,queryParam.getInspectItem());
		}
		if(StringHelper.isNotEmpty(queryParam.getInspectContent())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.INSPECT_CONTENT,queryParam.getInspectContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getIfComply())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.IF_COMPLY,queryParam.getIfComply());
		}
		if(StringHelper.isNotEmpty(queryParam.getProblem())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.PROBLEM,queryParam.getProblem());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSortNo())){
			queryWrapper.eq(TContractorDailyPlanInspectResult.SORT_NO,queryParam.getSortNo());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanInspectResult.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanInspectResult.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanInspectResult.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
