package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.common.util.BeanConverUtil;
import com.testor.module.contractor.common.model.constant.ContractorProcessStatus;
import com.testor.module.contractor.enums.ContractorFlowTypeEnum;
import com.testor.module.contractor.manage.dao.TContractorAllowDao;
import com.testor.module.contractor.manage.model.domain.TContractorAllow;
import com.testor.module.contractor.manage.model.domain.TContractorPreparation;
import com.testor.module.contractor.manage.model.dto.TContractorAllowDTO;
import com.testor.module.contractor.manage.model.dto.TContractorAllowParam;
import com.testor.module.contractor.manage.model.dto.TContractorAllowPersonParam;
import com.testor.module.contractor.manage.model.dto.TContractorPreparationParam;
import com.testor.module.contractor.manage.service.TContractorAllowService;
import com.testor.module.contractor.manage.service.TContractorPreparationService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.definition.controller.ProcessDefinitionController;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefStartParam;
import com.tongtech.tfw.workflow.apis.task.controller.WfTaskController;
import com.tongtech.tfw.workflow.apis.task.model.dto.CompleteTask;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * 准入管理Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-26 14:07:35
 */
@Service
public class TContractorAllowServiceImpl extends SuperServiceImpl<TContractorAllowDao, TContractorAllow> implements TContractorAllowService
{
    @Autowired(required = false)
    private TContractorAllowDao tContractorAllowDao;

    @Autowired
    private ProcessDefinitionController processDefinitionController;

    @Autowired
    private WfTaskController wfTaskController;

    @Autowired
    private TContractorPreparationService tContractorPreparationService;

    @Override
    public Page<TContractorAllowDTO> pageList(TContractorAllowParam param) {
        Long page=
                StringHelper.isEmpty(param.getPage())? BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorAllow> resultPage=new Page<>(page,limit);
        // TODO 根据需求修改查询条件及查询参数
        return tContractorAllowDao.pageList(resultPage,param);
    }

    @Override
    public void submit(TContractorAllowParam tContractorAllowPersonParam) {
        ProcessDefStartParam processDefStartParam = new ProcessDefStartParam("contractor");
        processDefStartParam.setBizKey(tContractorAllowPersonParam.getId());
        Map<String, Object> map = new HashMap<>();
        map.put("type", ContractorFlowTypeEnum.ADMIT.getCode());
        if (tContractorAllowPersonParam.getMap() != null){
            map.putAll(tContractorAllowPersonParam.getMap());
        }
        processDefStartParam.setVariables(map);
        String result = processDefinitionController.startProcessIns(processDefStartParam).getData().getResult();
        TContractorAllow tContractorAllow = BeanConverUtil.conver(tContractorAllowPersonParam, TContractorAllow.class);
        tContractorAllow.setProcessId(result);
        tContractorAllow.setProcessStatus(ContractorProcessStatus.UNDER_REVIEW.getValue());
        this.updateById(tContractorAllow);
    }

    @Override
    public void completeProcess(TContractorAllowParam tContractorAllowParam) {
        TContractorAllow tContractorAllow = this.getById(tContractorAllowParam.getId());
        String processStatus = tContractorAllowParam.getProcessStatus();
        CompleteTask completeTask = new CompleteTask();
        completeTask.setBizId(tContractorAllowParam.getId());
        completeTask.setTaskId(tContractorAllowParam.getTaskId());
        Map<String, Object> map = new HashMap<>();
        map.put("processStatus", processStatus);
        if (tContractorAllowParam.getMap() != null){
            map.putAll(tContractorAllowParam.getMap());
        }
        completeTask.setVars(map);
        wfTaskController.completeTask(completeTask).getData().getResult();
        // 创建一个TContractorBasicInfo对象
        tContractorAllow.setProcessStatus(processStatus);
        // 调用tContractorBasicInfoService的updateById方法，更新tContractorBasicInfo对象
        this.updateById(tContractorAllow);
        //如果审核状态为通过推送数据到开工准备
        if (processStatus.equals(ContractorProcessStatus.APPROVED.getValue())){
            TContractorPreparationParam tContractorPreparation = new TContractorPreparationParam();
            tContractorPreparation.setContractorId(tContractorAllow.getContractorId());
            tContractorPreparation.setBizId(tContractorAllow.getBizId());
            tContractorPreparation.setOrgId(tContractorAllow.getOrgId());
            tContractorPreparation.setProjId(tContractorAllow.getProjId());
            tContractorPreparation.setCreateBy(tContractorAllow.getCreateBy());
            tContractorPreparation.setUpdateBy(tContractorAllow.getUpdateBy());
            tContractorPreparationService.addEntity(tContractorPreparation);
        }
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorAllow> createQuery(TContractorAllowParam queryParam){
        QueryWrapper<TContractorAllow> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getContractorId())){
            queryWrapper.eq(TContractorAllow.CONTRACTOR_ID,queryParam.getContractorId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProjId())){
            queryWrapper.eq(TContractorAllow.PROJ_ID,queryParam.getProjId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProcessId())){
            queryWrapper.eq(TContractorAllow.PROCESS_ID,queryParam.getProcessId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProcessStatus())){
            queryWrapper.eq(TContractorAllow.PROCESS_STATUS,queryParam.getProcessStatus());
        }
        if(StringHelper.isNotEmpty(queryParam.getBizId())){
            queryWrapper.eq(TContractorAllow.BIZ_ID,queryParam.getBizId());
        }
        if(StringHelper.isNotEmpty(queryParam.getWorkDescription())){
            queryWrapper.eq(TContractorAllow.WORK_DESCRIPTION,queryParam.getWorkDescription());
        }
        if(StringHelper.isNotEmpty(queryParam.getWorkLocation())){
            queryWrapper.eq(TContractorAllow.WORK_LOCATION,queryParam.getWorkLocation());
        }
        if(StringHelper.isNotEmpty(queryParam.getWorkPlan())){
            queryWrapper.eq(TContractorAllow.WORK_PLAN,queryParam.getWorkPlan());
        }
        if(StringHelper.isNotEmpty(queryParam.getEmergencyPlan())){
            queryWrapper.eq(TContractorAllow.EMERGENCY_PLAN,queryParam.getEmergencyPlan());
        }
        if(StringHelper.isNotEmpty(queryParam.getHealthSafetyNotice())){
            queryWrapper.eq(TContractorAllow.HEALTH_SAFETY_NOTICE,queryParam.getHealthSafetyNotice());
        }
        if(StringHelper.isNotEmpty(queryParam.getSafetyCommitment())){
            queryWrapper.eq(TContractorAllow.SAFETY_COMMITMENT,queryParam.getSafetyCommitment());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorAllow.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorAllow.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorAllow.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
