package com.testor.module.duty.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@TableName("t_sys_duty")
@ApiModel(value = "TSysDuty对象", description = "")
@Data
public class TSysDuty {
    @ApiModelProperty(value = "人员id")
    @TableField("id")
    private String id ;
    @ApiModelProperty(value = "关联ID")
    @TableField("ref_id")
    private String refId ;
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId ;
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId ;
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId ;
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus ;
    @ApiModelProperty(value = "状态：0正常 1删除 2停用")
    @TableField("status")
    private String status ;
    @ApiModelProperty(value = "创建者")
    @TableField("create_by")
    private String createBy ;
    @ApiModelProperty(value = "创建时间")
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate ;
    @ApiModelProperty(value = "最后一次更新者")
    @TableField("update_by")
    private String updateBy ;
    @ApiModelProperty(value = "最后一次更新时间")
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate ;
    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks ;
    @ApiModelProperty(value = "值班日期", required = true)
    @TableField("duty_date")
    private String dutyDate ;
    @ApiModelProperty(value = "值班模式", required = true)
    @TableField("duty_pattern")
    private String dutyPattern ;
    @ApiModelProperty(value = "班次", required = true)
    @TableField("classes")
    private String classes ;
    @ApiModelProperty(value = "值班人姓名", required = true)
    @TableField("name")
    private String name ;
    @ApiModelProperty(value = "值班人所属部门", required = true)
    @TableField("dept_name")
    private String deptName ;
    @ApiModelProperty("部门id")
    @TableField("dept_id")
    private String deptId ;
    @ApiModelProperty(value = "值班人电话", required = true)
    @TableField("phone")
    private String phone ;
    @ApiModelProperty(value = "企业id", required = true)
    @TableField("company_id")
    private String companyId ;
    @ApiModelProperty(value = "企业名称")
    @TableField("company_name")
    private String companyName ;
    @ApiModelProperty(value = "租赁单位名称")
    @TableField("tenant_name")
    private String tenantName ;
    @ApiModelProperty(value = "单位归属", required = true)
    @TableField("unit_belong")
    private String unitBelong ;
    @ApiModelProperty(value = "是否领导", required = true)
    @TableField("is_leader")
    private String isLeader ;
    @ApiModelProperty(value = "调整原因")
    @TableField("adjust_cause")
    private String adjustCause ;
    @ApiModelProperty(value = "删除原因")
    @TableField("delete_cause")
    private String deleteCause;
    @ApiModelProperty(value = "审核人")
    @TableField("auditor")
    private String auditor;
    @ApiModelProperty(value = "是否创建了值班日志")
    @TableField("is_create_log")
    private String isCreateLog;
    @ApiModelProperty(value = "值班日志id")
    @TableField("duty_log_id")
    private String dutyLogId;
    @ApiModelProperty(value = "审核意见")
    @TableField("reject_opinion")
    private String rejectOpinion;
    @ApiModelProperty(value = "值班人员id")
    @TableField("user_id")
    private String userId ;
    @ApiModelProperty(value = "接收对象类型")
    @TableField("receiver_type")
    private String receiverType;
    @ApiModelProperty(value = "接收对象")
    @TableField("receiver_obj")
    private String receiverObj;
    @ApiModelProperty(value = "排序")
    @TableField("sort")
    private Integer sort;
}
