package com.testor.module.emergency.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 修订记录对象 t_contingency_plan_record
 * 
 * @author testor-framework
 * @date 2022-10-18 09:50:45
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contingency_plan_record")
@ApiModel(value = "TContingencyPlanRecord对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContingencyPlanRecord extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 修订内容
 */
  @ApiModelProperty(value = "修订内容")

  @TableField("record_content")
  private String recordContent;
/**
 * 修改时间
 */
  @ApiModelProperty(value = "修改时间")

  @TableField("record_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date recordTime;
/**
 * 附件名
 */
  @ApiModelProperty(value = "附件名")

  @TableField("accessory_name")
  private String accessoryName;
/**
 * 附件地址
 */
  @ApiModelProperty(value = "附件地址")

  @TableField("accessory_path")
  private String accessoryPath;
/**
 * 预案id
 */
  @ApiModelProperty(value = "预案id")

  @TableField("plan_id")
  private String planId;
/**
 * 附件id
 */
  @ApiModelProperty(value = "附件id")

  @TableField("accessory_id")
  private String accessoryId;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  public static final String RECORD_CONTENT ="record_content";
  public static final String RECORD_TIME ="record_time";
  public static final String ACCESSORY_NAME ="accessory_name";
  public static final String ACCESSORY_PATH ="accessory_path";
  public static final String PLAN_ID ="plan_id";
  public static final String ACCESSORY_ID ="accessory_id";
  public static final String ID ="id";
  public static final String ORG_ID ="org_id";


}
