package com.testor.module.emergency.model.vo;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.emergency.model.domain.TEmergencyGoods;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@Data
@ApiModel(value = "TEmergencyGoodsVO 对象", description = "")
public class TEmergencyGoodsVO extends TEmergencyGoods {
    /**
     * 物资类型名称
     */
    @ApiModelProperty(value = "物资类型名称")
    private String goodsTypeName;
    /**
     * 物资名称
     */
    @ApiModelProperty(value = "物资名称")
    private String goodsName;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String orgName;
    /**
     * 可领用数量
     */
    @ApiModelProperty(value = "可领用数量")
    private Integer ableNum;

    /**
     * 有效期
     */
    @ApiModelProperty(value = "")
    private String periodValidity ;
//-----------------------------------TEmergencyGoodsPosition
    /**
     * 配置数量
     */
    @ApiModelProperty(value = "配置数量" , example = "0")
    private Integer reserveNumPosition;
    /**
     * 存放位置
     */
    @ApiModelProperty(value = "存放位置")
    private String position;
    /**
     * 待维修更换数量
     */
    @ApiModelProperty(value = "待维修更换数量" , example = "0")
    private Integer repairNum;
    /**
     * 配置日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "配置日期")
    private Date reserveDate;

    private String businessOrgName;

    /**
     * 是否逾期 0否 1是
     */
    @ApiModelProperty(value = "是否逾期 0否 1是")
    private Integer isLate;

    public String getperiodValidity(){
        return DateUtil.format(getValidityStartDate(),"yyyy-MM-dd HH:mm:ss")+ " 至 "+DateUtil.format(getValidityEndDate(),"yyyy-MM-dd HH:mm:ss");
    }



}
