package com.testor.module.partner.controller;

import cn.hutool.core.util.ObjectUtil;
import com.testor.module.partner.model.dto.TJobStatisticsParam;
import com.testor.module.partner.model.vo.*;
import com.testor.module.partner.service.TJobStatisticsService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 现场作业统计Controller
 *
 * @author testor-framework
 * @date 2022-11-02 10:42:06
 */
@RestController
@RequestMapping("/partner/statistics")
@Api(value = "TJobStatistics", tags = "现场作业统计")
@Slf4j
public class TJobStatisticsController extends SuperController {
    @Autowired
    private TJobStatisticsService tJobStatisticsService;

    //
//    /* Generated Method*/
//	@ApiOperation(value = "新增 现场作业统计", notes = "Add TJobStatistics")
//	@PostMapping(value = "/add")
//	public BaseResponse<TJobStatistics>addEntity(@RequestBody TJobStatistics addRequest) {
//		BaseResponse<TJobStatistics> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(addRequest)){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//			String id = IdHelper.getId32bit();
//            TJobStatistics data=BeanHelper.beanToBean(addRequest,  TJobStatistics.class);
//			data.setId(id);
//		//	boolean result= tJobStatisticsService.save(data);
//
//			if(true){
//                TJobStatistics newEntity = new TJobStatistics();
//				newEntity.setId(id);
//				baseResponse.setData(newEntity);
//			}
//		}
//		return baseResponse;
//	}
    @ApiOperation(value = "外来作业相关方人次统计 ", notes = "")
    @PostMapping(value = "/foreignNum")
    public BaseResponse<List<DangerousNumVO>> foreignNum(@RequestBody TJobStatisticsParam param) {
        BaseResponse<List<DangerousNumVO>> baseResponse = new BaseResponse<>();
        List<DangerousNumVO> data;
        //粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getGrainDepotId())) {
            data = tJobStatisticsService.foreignGrainDepot(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司租力库数据统计
        if (ObjectUtil.isNotEmpty(param.getAreaId())) {
            data = tJobStatisticsService.foreignRentalLibrary(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getIds())) {
            data = tJobStatisticsService.foreignRegionalGrain(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //总部
        // TODO 按需求添加业务异常判断
        data = tJobStatisticsService.foreignHeadquarters(param);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "危险作业次数 ", notes = "")
    @PostMapping(value = "/statistics")
    public BaseResponse statistics() {
        BaseResponse baseResponse = new BaseResponse<>();
        tJobStatisticsService.addJob();
        baseResponse.setMsg("操作成功");
        return baseResponse;
    }

    @ApiOperation(value = "危险作业次数 ", notes = "")
    @PostMapping(value = "/dangerousNum")
    public BaseResponse<List<DangerousNumVO>> dangerousNum(@RequestBody TJobStatisticsParam param) {
        BaseResponse<List<DangerousNumVO>> baseResponse = new BaseResponse<>();
        List<DangerousNumVO> data;
        //粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getGrainDepotId())) {
            data = tJobStatisticsService.grainDepot(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司租力库数据统计
        if (ObjectUtil.isNotEmpty(param.getAreaId())) {
            data = tJobStatisticsService.area(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getIds())) {
            data = tJobStatisticsService.regionalGrain(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //总部
        // TODO 按需求添加业务异常判断
        data = tJobStatisticsService.dangerousNum(param);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "各类危险作业分布 ", notes = "")
    @PostMapping(value = "/dangerousDistribution")
    public BaseResponse<HazardousOperation> dangerousDistribution(@RequestBody TJobStatisticsParam param) {
        BaseResponse<HazardousOperation> baseResponse = new BaseResponse<>();
        HazardousOperation data;
        //粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getGrainDepotId())) {
            data = tJobStatisticsService.distributionGrainDepot(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getIds())) {
            data = tJobStatisticsService.distributionRegionalCompanyGrainDepot(param);
            baseResponse.setData(data);
            return baseResponse;
        }

        //区域公司租力库数据统计
        if (ObjectUtil.isNotEmpty(param.getAreaId())) {
            data = tJobStatisticsService.distributionRegionalCompaniesRentStorage(param);
            baseResponse.setData(data);
            return baseResponse;
        }

        //总部
            data = tJobStatisticsService.distributionSum(param);

        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "现场统计表格 ", notes = "")
    @PostMapping(value = "/fieldStatisticsForm")
    public BaseResponse<List<FieldStatisticsFormVO>> fieldStatisticsForm(@RequestBody TJobStatisticsParam param) {
        BaseResponse<List<FieldStatisticsFormVO>> baseResponse = new BaseResponse<>();
        List<FieldStatisticsFormVO> data;
        //粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getGrainDepotId())) {
            data = tJobStatisticsService.fieldStatisticsFormSingle(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //区域公司粮库数据统计
        if (ObjectUtil.isNotEmpty(param.getIds())) {
            data = tJobStatisticsService.fieldStatisticsFormGrainDepot(param);
            baseResponse.setData(data);
            return baseResponse;
        }

        //区域公司租力库数据统计
        if (ObjectUtil.isNotEmpty(param.getAreaId())) {
            data = tJobStatisticsService.fieldStatisticsFormRegionalCorporateRentalLibrary(param);
            baseResponse.setData(data);
            return baseResponse;
        }
        //总部
        data = tJobStatisticsService.fieldStatisticsFormHeadquarters(param);

        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "首页危险作业", notes = "")
    @GetMapping(value = "/homeHeadquarters/regionalStatistics")
    public BaseResponse<HazardousWorkStatisticsVo> regionalStatistics(String orgId) {
        HazardousWorkStatisticsVo regionalStatisticsVOS = tJobStatisticsService.regionalStatistics(orgId);
        BaseResponse<HazardousWorkStatisticsVo> listBaseResponse = new BaseResponse<>();
        listBaseResponse.setData(regionalStatisticsVOS);
        return listBaseResponse;
    }
    @ApiOperation(value = "首页危险作业（总部、区域），本日计划进行", notes = "")
    @GetMapping(value = "/homeHeadquarters/regionalStatisticsCount")
    public BaseResponse<Long> regionalStatisticsCount(String orgId) {
        Long count = tJobStatisticsService.regionalStatisticsCount(orgId);
        BaseResponse<Long> listBaseResponse = new BaseResponse<>();
        listBaseResponse.setData(count);
        return listBaseResponse;
    }
}
