package com.testor.module.partner.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.testor.module.partner.model.domain.TPartnerType;

/**
 * 相关方类型 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-01 14:19:22
 */

@Data
@ApiModel(value = "TPartnerType 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TPartnerTypeParam extends TPartnerType {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
