package com.testor.module.partner.model.vo;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * 相关方组织机构对象 t_partner_org
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
public class PartnerOrgBlacklistVO extends SuperModel {
    private String id;
    /**
     * 相关方id
     */
    @ApiModelProperty(value = "相关方id")
    private String partnerId;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "相关方单位名称")
    private String partnerName;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    /**
     * 法定代表人
     */
    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）,默认1", example = "1")
    private Integer certificateStatus;

    /**
     * 黑名单操作单位
     */
    @ApiModelProperty(value = "黑名单操作单位")
    private String orgName;

    /**
     * 黑名单原因
     */
    @ApiModelProperty(value = "黑名单原因")
    private String blacklistReason;

    public static void main(String[] args) {
        BigDecimal b0=new BigDecimal(0);
        BigDecimal b1=new BigDecimal(1);
        BigDecimal b2=new BigDecimal(0);


        System.out.println(b0.compareTo(b1));
        System.out.println(b0.compareTo(b2));
    }

}
