package com.testor.module.safeCheck.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.safeCheck.model.domain.TSafeCheckTaskRecord;

/**
 * 安全检查任务流程记录 删除参数对象
 *
 * @author testor-framework
 * @date 2024-09-05 09:25:46
 */

@Data
@ApiModel(value = "TSafeCheckTaskRecord 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeCheckTaskRecordParam extends TSafeCheckTaskRecord {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
