/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.internal;

import com.tongweb.commons.monitor.core.instrument.AbstractMeter;
import com.tongweb.commons.monitor.core.instrument.Gauge;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.util.MeterEquivalence;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultGauge<T>
extends AbstractMeter
implements Gauge {
    private static final Log logger = LogFactory.getLog((String)"monitor");
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;

    public DefaultGauge(Meter.Id id, T obj, ToDoubleFunction<T> value) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.value = value;
    }

    @Override
    public double value() {
        Object obj = this.ref.get();
        if (obj != null) {
            try {
                return this.value.applyAsDouble(this.ref.get());
            }
            catch (Throwable ex) {
                logger.warn((Object)("Failed to apply the value function for the gauge '" + this.getId().getName() + "'."), ex);
            }
        }
        return Double.NaN;
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

