/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.excel.service;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.testor.biz.excel.ExcelEnum;
import com.testor.biz.excel.model.ImportCheckResult;
import com.testor.biz.excel.model.ImportError;
import com.testor.biz.excel.service.ImportCheckService;
import com.testor.biz.excel.support.ExcelValidationHelper;
import com.tongtech.tfw.backend.common.models.exceptions.ServiceException;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TongExcelListener<T>
extends AnalysisEventListener<T> {
    private List<T> successList = new ArrayList<T>();
    private List<ImportError<T>> errorList = new ArrayList<ImportError<T>>();
    private ImportCheckService<T> importCheckService;
    Map<String, T> insertMap = new HashMap<String, T>();
    private Class<T> clazz;
    private boolean insertTrigger = true;

    public TongExcelListener(ImportCheckService<T> importCheckService, Class<T> clazz) {
        this.importCheckService = importCheckService;
        this.clazz = clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(T t, AnalysisContext analysisContext) {
        String errMsg;
        int currentRow = analysisContext.readRowHolder().getRowIndex();
        try {
            errMsg = ExcelValidationHelper.validateModel(t);
        }
        catch (NoSuchFieldException e) {
            throw new ServiceException(ExcelEnum.NO_SUCH_MODEL.transform());
        }
        if (StringHelper.isNotEmpty((CharSequence)errMsg)) {
            ImportError importError = ImportError.builder().errorMsg(errMsg).lineNumber(currentRow).data(t).build();
            if (this.errorList.size() >= 20) return;
            this.errorList.add(importError);
        } else {
            this.insertMap.put(currentRow + "", t);
        }
        if (this.errorList.size() > 0) {
            this.insertTrigger = true;
        }
        if (this.insertMap.keySet().size() <= 100) return;
        ImportCheckResult<T> importCheckResult = this.importCheckService.doImportData(this.insertMap, this.insertTrigger);
        this.successList.addAll(importCheckResult.getSuccessData());
        this.errorList.addAll(importCheckResult.getErrorData());
        this.insertMap.clear();
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        ImportCheckResult<T> importCheckResult = this.importCheckService.doImportData(this.insertMap, this.insertTrigger);
        this.successList.addAll(importCheckResult.getSuccessData());
        this.errorList.addAll(importCheckResult.getErrorData());
        this.errorList.sort(Comparator.naturalOrder());
        this.insertMap.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TongExcelListener)) {
            return false;
        }
        TongExcelListener other = (TongExcelListener)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isInsertTrigger() != other.isInsertTrigger()) {
            return false;
        }
        List<T> this$successList = this.getSuccessList();
        List<T> other$successList = other.getSuccessList();
        if (this$successList == null ? other$successList != null : !((Object)this$successList).equals(other$successList)) {
            return false;
        }
        List<ImportError<T>> this$errorList = this.getErrorList();
        List<ImportError<T>> other$errorList = other.getErrorList();
        if (this$errorList == null ? other$errorList != null : !((Object)this$errorList).equals(other$errorList)) {
            return false;
        }
        ImportCheckService<T> this$importCheckService = this.getImportCheckService();
        ImportCheckService<T> other$importCheckService = other.getImportCheckService();
        if (this$importCheckService == null ? other$importCheckService != null : !this$importCheckService.equals(other$importCheckService)) {
            return false;
        }
        Map<String, T> this$insertMap = this.getInsertMap();
        Map<String, T> other$insertMap = other.getInsertMap();
        if (this$insertMap == null ? other$insertMap != null : !((Object)this$insertMap).equals(other$insertMap)) {
            return false;
        }
        Class<T> this$clazz = this.getClazz();
        Class<T> other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TongExcelListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isInsertTrigger() ? 79 : 97);
        List<T> $successList = this.getSuccessList();
        result = result * 59 + ($successList == null ? 43 : ((Object)$successList).hashCode());
        List<ImportError<T>> $errorList = this.getErrorList();
        result = result * 59 + ($errorList == null ? 43 : ((Object)$errorList).hashCode());
        ImportCheckService<T> $importCheckService = this.getImportCheckService();
        result = result * 59 + ($importCheckService == null ? 43 : $importCheckService.hashCode());
        Map<String, T> $insertMap = this.getInsertMap();
        result = result * 59 + ($insertMap == null ? 43 : ((Object)$insertMap).hashCode());
        Class<T> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public List<T> getSuccessList() {
        return this.successList;
    }

    public List<ImportError<T>> getErrorList() {
        return this.errorList;
    }

    public ImportCheckService<T> getImportCheckService() {
        return this.importCheckService;
    }

    public Map<String, T> getInsertMap() {
        return this.insertMap;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public boolean isInsertTrigger() {
        return this.insertTrigger;
    }

    public void setSuccessList(List<T> successList) {
        this.successList = successList;
    }

    public void setErrorList(List<ImportError<T>> errorList) {
        this.errorList = errorList;
    }

    public void setImportCheckService(ImportCheckService<T> importCheckService) {
        this.importCheckService = importCheckService;
    }

    public void setInsertMap(Map<String, T> insertMap) {
        this.insertMap = insertMap;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setInsertTrigger(boolean insertTrigger) {
        this.insertTrigger = insertTrigger;
    }

    public String toString() {
        return "TongExcelListener(successList=" + this.getSuccessList() + ", errorList=" + this.getErrorList() + ", importCheckService=" + this.getImportCheckService() + ", insertMap=" + this.getInsertMap() + ", clazz=" + this.getClazz() + ", insertTrigger=" + this.isInsertTrigger() + ")";
    }
}

