/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dv2.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dv2.dao.BladeVisualDao;
import com.tongtech.tfw.dv2.model.domain.BladeVisual;
import com.tongtech.tfw.dv2.model.domain.BladeVisualConfig;
import com.tongtech.tfw.dv2.model.dto.VisualDTO;
import com.tongtech.tfw.dv2.service.BladeVisualConfigService;
import com.tongtech.tfw.dv2.service.BladeVisualService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BladeVisualServiceImpl
extends SuperServiceImpl<BladeVisualDao, BladeVisual>
implements BladeVisualService {
    @Autowired(required=false)
    private BladeVisualDao bladeVisualDao;
    @Autowired(required=false)
    private BladeVisualConfigService bladeVisualConfigService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public VisualDTO saveComb(VisualDTO dataViewDTO, String userId) {
        String id = IdHelper.getId32bit();
        BladeVisual data = (BladeVisual)BeanHelper.beanToBean((Object)dataViewDTO.getVisual(), BladeVisual.class);
        data.setId(id);
        boolean result = this.save(data);
        if (result) {
            BladeVisualConfig config = (BladeVisualConfig)BeanHelper.beanToBean((Object)dataViewDTO.getConfig(), BladeVisualConfig.class);
            config.setId(id);
            config.setVisualId(id);
            this.bladeVisualConfigService.save(config);
        }
        return dataViewDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateComb(VisualDTO dataViewDTO, String userId) {
        boolean dataRe = true;
        boolean confRe = true;
        if (ObjectHelper.isNotEmpty((Object)dataViewDTO.getVisual()) && StringHelper.isNotEmpty((CharSequence)dataViewDTO.getVisual().getId())) {
            BladeVisual data = (BladeVisual)BeanHelper.beanToBean((Object)dataViewDTO.getVisual(), BladeVisual.class);
            dataRe = this.updateById(data);
        }
        if (ObjectHelper.isNotEmpty((Object)dataViewDTO.getConfig()) && StringHelper.isNotEmpty((CharSequence)dataViewDTO.getConfig().getId())) {
            BladeVisualConfig config = (BladeVisualConfig)BeanHelper.beanToBean((Object)dataViewDTO.getConfig(), BladeVisualConfig.class);
            confRe = this.bladeVisualConfigService.updateById(config);
        }
        return dataRe && confRe;
    }

    @Override
    public String copyDataView(String id, String userId) {
        BladeVisual dataView = (BladeVisual)this.getById((Serializable)((Object)id));
        BladeVisualConfig dataViewConfig = (BladeVisualConfig)this.bladeVisualConfigService.getOne((Wrapper)new QueryWrapper().lambda().eq(BladeVisualConfig::getVisualId, (Object)id));
        if (dataView != null && dataViewConfig != null) {
            dataView.setId(null);
            dataViewConfig.setId(null);
            VisualDTO dto = new VisualDTO();
            dto.setVisual(dataView);
            dto.setConfig(dataViewConfig);
            VisualDTO save = this.saveComb(dto, userId);
            if (null != save) {
                return save.getVisual().getId();
            }
        }
        return null;
    }
}

