/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.model.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.model.model.domain.ActDeModel;
import com.tongtech.tfw.workflow.apis.model.model.dto.ModelListRequest;
import com.tongtech.tfw.workflow.apis.model.model.dto.ModelListResponse;
import com.tongtech.tfw.workflow.apis.model.model.dto.ModelOpRequest;
import com.tongtech.tfw.workflow.apis.model.service.ActDeModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelRelation;
import org.flowable.ui.modeler.repository.ModelRelationRepository;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Model Controller", tags={"WF\u6a21\u578b\u7ba1\u7406"})
@RequestMapping(value={"/wf/model"})
public class ModelController {
    private static final Logger log = LoggerFactory.getLogger(ModelController.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    ModelRelationRepository modelRelationRepository;
    @Autowired
    FormRepositoryService formRepositoryService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActDeModelService actDeModelService;

    @ApiOperation(value="\u6d41\u7a0b\u6a21\u578b\u5217\u8868", notes="List Models Definition")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<ModelListResponse>> modelList(ModelListRequest modelListRequest) {
        BaseResponse baseResponseListBaseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)modelListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(modelListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)modelListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(modelListRequest.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_type", (Object)0);
        if (StringHelper.isNotEmpty((CharSequence)modelListRequest.getName())) {
            queryWrapper.like((Object)"name", (Object)modelListRequest.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)modelListRequest.getKey())) {
            queryWrapper.like((Object)"model_key", (Object)modelListRequest.getKey());
        }
        Page queryList = (Page)this.actDeModelService.page((IPage)resultPage, (Wrapper)queryWrapper);
        ArrayList<ModelListResponse> resultList = new ArrayList<ModelListResponse>();
        for (ActDeModel actDeModel : queryList.getRecords()) {
            String createdByUser = actDeModel.getCreatedBy();
            resultList.add(ModelListResponse.builder().modelId(actDeModel.getId()).name(actDeModel.getName()).key(actDeModel.getModelKey()).version(actDeModel.getVersion().longValue()).metaInfo(actDeModel.getModelComment()).createTime(actDeModel.getCreated()).updateTime(actDeModel.getLastUpdated()).createBy(createdByUser).build());
        }
        BaseResponseList responseList = new BaseResponseList();
        responseList.setData(resultList);
        responseList.setTotal(queryList.getTotal());
        baseResponseListBaseResponse.setData((Object)responseList);
        return baseResponseListBaseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u6a21\u578b\u4e0b\u8f7d", notes="Get Model XML By id")
    @GetMapping(value={"/download"})
    public void downloadXml(@Valid ModelOpRequest modelOpRequest, HttpServletResponse response) {
        Model model;
        if (StringHelper.isNotEmpty((CharSequence)modelOpRequest.getModelId()) && ObjectHelper.isNotEmpty((Object)(model = this.modelService.getModel(modelOpRequest.getModelId())))) {
            try {
                response.setHeader("Content-Type", "text/xml;charset=UTF-8");
                byte[] b = this.modelService.getBpmnXML((AbstractModel)model);
                IOUtils.write((byte[])b, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                log.error("Get Model XML error: " + e);
            }
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u6a21\u578b\u5220\u9664", notes="Delete Model by id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteProcDef(@RequestBody @Valid ModelOpRequest deleteReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)deleteReq.getModelId())) {
            this.modelService.deleteModel(deleteReq.getModelId());
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result("\u5220\u9664\u6210\u529f").build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u6a21\u578b\u90e8\u7f72", notes="Deploy Model by id")
    @PostMapping(value={"/deploy"})
    public BaseResponse<BizGeneralResponse> deployModel(@RequestBody @Valid ModelOpRequest deployReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)deployReq.getModelId())) {
            Model model = this.modelService.getModel(deployReq.getModelId());
            BpmnModel bpmnModel = this.modelService.getBpmnModel((AbstractModel)model);
            try {
                Deployment deploy = this.repositoryService.createDeployment().name(model.getName()).key(model.getKey()).category(deployReq.getCategory()).addBpmnModel(model.getKey() + ".bpmn", bpmnModel).deploy();
                List modelRelations = this.modelRelationRepository.findByParentModelIdAndType(model.getId(), "form-model");
                for (ModelRelation modelRelation : modelRelations) {
                    Model form = this.modelService.getModel(modelRelation.getModelId());
                    this.formRepositoryService.createDeployment().parentDeploymentId(deploy.getId()).name(form.getName()).addFormDefinition(form.getName() + ".form", form.getModelEditorJson()).deploy();
                }
                BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result("\u6a21\u578b\u90e8\u7f72\u6210\u529f, Dep ID:" + deploy.getId()).build();
                baseResponse.setData((Object)bizGeneralResponse);
            }
            catch (Exception e) {
                log.error("Model Deploy Error: ", (Throwable)e);
                BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result("\u90e8\u7f72\u64cd\u4f5c\u5931\u8d25").build();
                baseResponse.setData((Object)bizGeneralResponse);
            }
        }
        return baseResponse;
    }
}

