package com.testor.ddd.safetyControl.interfaces.model.dto.lecls;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * lec ls 数值配置信息对象 t_safe_risk_lecls_conf
 *
 * @author testor-framework
 * @date 2022-07-27 14:11:57
 */
@Data
public class RiskLeclsValDTO implements Serializable {

    /**
     * 1-lec;2-ls
     */
    @ApiModelProperty(value = "1-lec;2-ls ", example = "0")
    private Integer type;

    /**
     * 1-lec;2-ls
     */
    @ApiModelProperty(value = "1-采用范围值，2-采用具体值")
    private Integer valueType;

    @ApiModelProperty(value = "LecL")
    private Float LecL;

    @ApiModelProperty(value = "LecE")
    private Float LecE;

    @ApiModelProperty(value = "LecC")
    private Float LecC;

    @ApiModelProperty(value = "LsL")
    private Float LsL;

    @ApiModelProperty(value = "LsS")
    private Float LsS;

    @ApiModelProperty(value = "根据lec/ls 公式计算值，前端不管")
    private float value;
}
