package com.testor.module.accident.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.accident.model.domain.AccidentPersonnel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 事故统计详情表
 */
@Data
public class AccidentReportDetailTemplate {

    @ExcelProperty("序号")
    private String number;

    @ExcelProperty("序号")
    private String id;

    @ExcelProperty("序号")
    private String currentOrgName;

    @ExcelProperty("序号")
    private String businessDeptName;

    @ExcelProperty("序号")
    private String regionName;
    /**
     * 事故发生时间
     */
    @ExcelProperty("事故发生时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date accidentTime;

    /**
     * 事故等级（国家）(字典:accident_level_country)
     */
    @ExcelProperty("事故等级（国家）(字典:accident_level_country)")
    private String accidentLevelCountry;

    @ExcelProperty("事故等级(集团)")
    private  String accidentLevel;

    @ExcelProperty("受伤人数")
    private  Integer reportCount;

    /**
     * 直接经济损失
     */
    @ExcelProperty("直接经济损失")
    private BigDecimal directEconomicLoss;

    /**
     * 损失工作日
     */
    @ExcelProperty("损失工作日")
    @TableField("lost_working_days")
    private String lostWorkingDays;

    /**
     * 人员信息
     */
    @ExcelProperty("人员信息")
    private List<AccidentPersonnel> accidentPersonnelList;

    @ExcelProperty("事故类型")
    private String accidentType;

    /**
     * 涉及集团八大类风险(多选 字典:group_risk)
     */
    @ExcelProperty("多选 涉及集团八大类风险(字典:group_risk)")
    private String groupRiskDetail;

    /**
     * 涉及危险作业类型(多选 字典:dangerous_homework_category)
     */
    @ExcelProperty("多选 涉及危险作业类型(字典:dangerous_homework_category)")
    private String dangerousHomeworkCategoryDetail;

    /**
     * 受伤部位(多选 字典:injured_area)
     */
    @ExcelProperty("多选 受伤部位(字典:injured_area)")
    private String injuredAreaDetail;
    /**
     * 事故详细经过
     */
    @ExcelProperty("事故详细经过")
    private String accidentPassed;

    /**
     * 事故直接原因和间接原因
     */
    @ExcelProperty("事故直接原因和间接原因")
    private String accidentCause;

    /**
     * 改善措施
     */
    @ExcelProperty("改善措施")
    private String improvements;

    /**
     * 事故人员追责问责情况
     */
    @ExcelProperty("事故人员追责问责情况")
    private String personnelAccountabilityStatus;

    /**
     * 备注
     */
    @ExcelProperty("备注")
    private String remarks;

}
