package com.testor.module.contractor.ledger.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.contractor.ledger.model.domain.TContractorContract;

/**
 * 承包商合同 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-19 10:20:52
 */

@Data
@ApiModel(value = "TContractorContract 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorContractParam extends TContractorContract {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
