package com.testor.module.contractor.manage.model.dto;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.manage.model.domain.TContractorPreparation;
import com.testor.module.contractor.manage.model.domain.TContractorPreparationAnalysis;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "ContractorSafetyBriefContentDto", description = "安全交底清单确认信息聚合实体")
public class ContractorSafetyBriefContentDto {
    @ApiModelProperty(value = "相关人员分工")
    private Page<TContractorPerson> personPage;

    @ApiModelProperty(value = "作业风险分析")
    private Page<TContractorPreparationAnalysis> preparationAnalysisPage;

    @ApiModelProperty(value = "劳动防护用品")
    private Page<TContractorProtectiveEquipment> protectiveEquipmentPage;

    @ApiModelProperty(value = "应急管理，对应开工准备对象中的施工方案和应急预案")
    private TContractorPreparation preparation;
}
