package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;


/**
 * 应急物资存储信息对象 t_emergency_goods_position
 * 
 * @author testor-framework
 * @date 2022-10-08 17:31:37
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_goods_position")
@ApiModel(value = "TEmergencyGoodsPosition对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyGoodsPosition extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 应急物品id
 */
  @ApiModelProperty(value = "应急物品id")

  @TableField("goods_id")
  private String goodsId;
/**
 * 存放位置
 */
  @ApiModelProperty(value = "存放位置")

  @TableField("position")
  private String position;
/**
 * 配置数量
 */
  @ApiModelProperty(value = "配置数量" , example = "0")
  @TableField("reserve_num_position")
  private Integer reserveNumPosition;
/**
 * 待维修更换数量
 */
  @ApiModelProperty(value = "待维修更换数量" , example = "0")
  @TableField("repair_num")
  private Integer repairNum = 0;
/**
 * 配置日期
 */
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @ApiModelProperty(value = "配置日期")
  @TableField("reserve_date")
  private Date reserveDate;

  /**
   * 空间场所id
   */
  @ApiModelProperty(value = "空间场所id")
  @TableField("space_id")
  @NotBlank(message = "存放位置不能为空")
  private String spaceId;

  public static final String ID ="id";
  public static final String GOODS_ID ="goods_id";
  public static final String POSITION ="position";
  public static final String RESERVE_NUM ="reserve_num";
  public static final String REPAIR_NUM ="repair_num";
  public static final String RESERVE_DATE ="reserve_date";


}
