package com.testor.module.emergency.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.dao.TEmergencyWorkingUserDao;
import com.testor.module.emergency.model.domain.TEmergencyWorkingUser;
import com.testor.module.emergency.model.dto.TEmergencyWorkingUserParam;
import com.testor.module.emergency.model.vo.TEmergencyWorkingUserVO;
import com.testor.module.emergency.service.TEmergencyWorkingUserService;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 应急救援小组人员Service业务层处理
 *
 * @author testor-framework
 * @date 2022-11-17 11:52:10
 */
@Service
public class TEmergencyWorkingUserServiceImpl extends SuperServiceImpl<TEmergencyWorkingUserDao, TEmergencyWorkingUser> implements TEmergencyWorkingUserService {

    @Autowired(required = false)
    private TEmergencyWorkingUserDao tEmergencyWorkingUserDao;

    @Override
    public boolean addAndUpdateUser(TEmergencyWorkingUser tEmergencyWorkingUser) throws BusinessException {
        //判断id是否为空，为空添加，否则新增
        if (ObjectUtil.isEmpty(tEmergencyWorkingUser.getId())) {
            //校验人员是否已添加
            List<TEmergencyWorkingUser> list = this.list(new LambdaQueryWrapper<TEmergencyWorkingUser>().eq(SuperModel::getStatus, 0)
                    .eq(TEmergencyWorkingUser::getGroupId, tEmergencyWorkingUser.getGroupId())
                    .eq(TEmergencyWorkingUser::getUserId, tEmergencyWorkingUser.getUserId()));
            if (ObjectUtil.isNotEmpty(list)) {
                throw new BusinessException("人员不可重复添加");
            }
            this.save(tEmergencyWorkingUser);
        } else {
            //校验人员是否已添加
            List<TEmergencyWorkingUser> list = this.list(new LambdaQueryWrapper<TEmergencyWorkingUser>().eq(SuperModel::getStatus, 0)
                    .eq(TEmergencyWorkingUser::getGroupId, tEmergencyWorkingUser.getGroupId())
                    .eq(TEmergencyWorkingUser::getUserId, tEmergencyWorkingUser.getUserId())
                    .ne(TEmergencyWorkingUser ::getId,tEmergencyWorkingUser.getId())
            );
            if (list.size() > 0){
                throw new BusinessException("人员在该组已存在");
            }
            this.updateById(tEmergencyWorkingUser);
        }
        return true;
    }

    @Override
    public IPage getUserList(TEmergencyWorkingUserParam tEmergencyWorkingUserParam) {
        Page<TEmergencyWorkingUserVO> tEmergencyWorkingUserVOPage = tEmergencyWorkingUserVOPage = new Page<>();
        if (ObjectUtil.isNotEmpty(tEmergencyWorkingUserParam.getPage()) && ObjectUtil.isNotEmpty(tEmergencyWorkingUserParam.getLimit())) {

            tEmergencyWorkingUserVOPage.setCurrent(tEmergencyWorkingUserParam.getPage());
            tEmergencyWorkingUserVOPage.setSize(tEmergencyWorkingUserParam.getLimit());
        } else {
            tEmergencyWorkingUserVOPage.setCurrent(-1);
            tEmergencyWorkingUserVOPage.setSize(-1);
        }

        if (ObjectUtil.isEmpty(tEmergencyWorkingUserParam.getIds())) {
            tEmergencyWorkingUserParam.setIds(null);
        }
        return tEmergencyWorkingUserDao.getUserList(tEmergencyWorkingUserVOPage, tEmergencyWorkingUserParam);
    }


}
