package com.testor.module.environment.model.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 节能环保月报对象 t_environment_monthly
 *
 * @author testor-framework
 * @date 2022-10-25 15:29:35
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_environment_monthly")
@ApiModel(value = "TEnvironmentMonthly对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEnvironmentMonthly extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @ApiModelProperty(value = " 主键")

    @TableId("id")
    private String id;
    /**
     * 机构id
     */
    @ApiModelProperty(value = "机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 机构名称
     */
    @ApiModelProperty(value = "机构名称")

    @TableField("org_name")
    private String orgName;
    /**
     * 上报日期
     */
    @ApiModelProperty(value = "上报日期")

    @TableField("month")
    private String month;
    /**
     * 煤炭(能源消耗量)
     */
    @ApiModelProperty(value = "煤炭(能源消耗量)")
    @TableField("energy_coal")
    private String energyCoal;


    /**
     * 原煤（实物量）
     */
    @ApiModelProperty(value = "原煤（实物量）")

    @TableField("energy_coal_amount")
    private String energyCoalAmount;


    /**
     * 电力(能源消耗量)
     */
    @ApiModelProperty(value = "电力(能源消耗量)")

    @TableField("energy_power")
    private String energyPower;
    /**
     * 汽油(能源消耗量)
     */
    @ApiModelProperty(value = "汽油(能源消耗量)")

    @TableField("energy_gasoline")
    private String energyGasoline;
    /**
     * 柴油(能源消耗量)
     */
    @ApiModelProperty(value = "柴油(能源消耗量)")

    @TableField("energy_derv")
    private String energyDerv;
    /**
     * 燃料油(能源消耗量)
     */
    @ApiModelProperty(value = "燃料油(能源消耗量)")

    @TableField("energy_fuel")
    private String energyFuel;
    /**
     * 天然气(能源消耗量)
     */
    @ApiModelProperty(value = "天然气(能源消耗量)")

    @TableField("energy_natural")
    private String energyNatural;
    /**
     * 热力(能源消耗量)
     */
    @ApiModelProperty(value = "热力(能源消耗量)")

    @TableField("energy_heating")
    private String energyHeating;
    /**
     * 其它能源(能源消耗量)
     */
    @ApiModelProperty(value = "其它能源(能源消耗量)")

    @TableField("energy_other")
    private String energyOther;
    /**
     * 综合能源消耗量(能源消耗量)
     */
    @ApiModelProperty(value = "综合能源消耗量(能源消耗量)")

    @TableField("energy_synthesize")
    private String energySynthesize;
    /**
     * 用新水量(用水量)
     */
    @ApiModelProperty(value = "用新水量(用水量)")

    @TableField("water_new")
    private String waterNew;
    /**
     * 重复用水量(用水量)
     */
    @ApiModelProperty(value = "重复用水量(用水量)")

    @TableField("water_repetition")
    private String waterRepetition;
    /**
     * 重复用水率(用水量)
     */
    @ApiModelProperty(value = "重复用水率(用水量)")

    @TableField("water_rate")
    private String waterRate;
    /**
     * 废水排放量(水污染物 排入外环境 废水排放量)
     */
    @ApiModelProperty(value = "废水排放量(水污染物 排入外环境 废水排放量)")

    @TableField("w_pollutant_o_discharge")
    private String wPollutantODischarge;
    /**
     * 化学需氧量排放量COD (水污染物 排入外环境 废水排放量)
     */
    @ApiModelProperty(value = " 化学需氧量排放量COD (水污染物 排入外环境 废水排放量)")

    @TableField("w_pollutant_o_cod")
    private String wPollutantOCod;
    /**
     * 氨氮排放量 (水污染物 排入外环境 废水排放量)
     */
    @ApiModelProperty(value = " 氨氮排放量 (水污染物 排入外环境 废水排放量)")

    @TableField("w_pollutant_o_NH3N")
    private String wPollutantONh3n;
    /**
     * 废水排放量(水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)
     */
    @ApiModelProperty(value = "废水排放量(水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")

    @TableField("w_pollutant_i_discharge")
    private String wPollutantIDischarge;
    /**
     * 化学需氧量排放量COD (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)
     */
    @ApiModelProperty(value = " 化学需氧量排放量COD (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")

    @TableField("w_pollutant_i_cod")
    private String wPollutantICod;
    /**
     * 氨氮排放量 (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)
     */
    @ApiModelProperty(value = " 氨氮排放量 (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")

    @TableField("w_pollutant_i_NH3N")
    private String wPollutantINh3n;
    /**
     * 废水排放量(水污染物  第三方运收 废水排放量)
     */
    @ApiModelProperty(value = "废水排放量(水污染物  第三方运收 废水排放量)")

    @TableField("w_pollutant_third_discharge")
    private String wPollutantThirdDischarge;
    /**
     * 化学需氧量排放量COD (水污染物  第三方运收 废水排放量)
     */
    @ApiModelProperty(value = " 化学需氧量排放量COD (水污染物  第三方运收 废水排放量)")

    @TableField("w_pollutant_third_cod")
    private String wPollutantThirdCod;
    /**
     * 氨氮排放量 (水污染物  第三方运收 废水排放量)
     */
    @ApiModelProperty(value = " 氨氮排放量 (水污染物  第三方运收 废水排放量)")

    @TableField("w_pollutant_third_NH3N")
    private String wPollutantThirdNh3n;
    /**
     * 合计(水污染物 废水排放量)
     */
    @ApiModelProperty(value = "合计(水污染物 废水排放量)")

    @TableField("w_pollutant_discharge_sum")
    private String wPollutantDischargeSum;
    /**
     * 合计(水污染物 化学需氧量排放量（COD）)
     */
    @ApiModelProperty(value = "合计(水污染物 化学需氧量排放量（COD）)")

    @TableField("w_pollutant_cod_sum")
    private String wPollutantCodSum;
    /**
     * 合计(水污染物  氨氮排放量)
     */
    @ApiModelProperty(value = "合计(水污染物  氨氮排放量)")

    @TableField("w_pollutant_NH3N_sum")
    private String wPollutantNh3nSum;
    /**
     * 烟（粉）尘排放量(大气污染物)
     */
    @ApiModelProperty(value = "烟（粉）尘排放量(大气污染物)")

    @TableField("atmosphere_pollutant_stack")
    private String atmospherePollutantStack;
    /**
     * 二氧化硫排放量(大气污染物)
     */
    @ApiModelProperty(value = "二氧化硫排放量(大气污染物)")

    @TableField("atmosphere_pollutant_so2")
    private String atmospherePollutantSo2;
    /**
     * 氮氧化物排放量(大气污染物)
     */
    @ApiModelProperty(value = "氮氧化物排放量(大气污染物)")

    @TableField("atmosphere_pollutant_NH3n")
    private String atmospherePollutantNh3n;
    /**
     * 挥发性有机物排放量(大气污染物)
     */
    @ApiModelProperty(value = "挥发性有机物排放量(大气污染物)")

    @TableField("atmosphere_pollutant_NH3n_organic")
    private String atmospherePollutantNh3nOrganic;
    /**
     * 二氧化碳排放量（测量值）(大气污染物)
     */
    @ApiModelProperty(value = " 二氧化碳排放量（测量值）(大气污染物)")

    @TableField("atmosphere_pollutant_NH3n_co2")
    private String atmospherePollutantNh3nCo2;
    /**
     * 二氧化碳排放量（计算值）(大气污染物)
     */
    @ApiModelProperty(value = " 二氧化碳排放量（计算值）(大气污染物)")

    @TableField("atmosphere_pollutant_NH3n_count")
    private String atmospherePollutantNh3nCount;
    /**
     * 炉渣(一般固体废物)
     */
    @ApiModelProperty(value = " 炉渣(一般固体废物)")

    @TableField("solid_slag")
    private String solidSlag;
    /**
     * 筛下物(一般固体废物)
     */
    @ApiModelProperty(value = " 筛下物(一般固体废物)")

    @TableField("solid_sieve")
    private String solidSieve;
    /**
     * 其它固废(一般固体废物)
     */
    @ApiModelProperty(value = " 其它固废(一般固体废物)")

    @TableField("solid_other")
    private String solidOther;
    /**
     * 一般固体废物产生量(一般固体废物)
     */
    @ApiModelProperty(value = " 一般固体废物产生量(一般固体废物)")

    @TableField("solid_produce")
    private String solidProduce;
    /**
     * 综合利用量(一般固体废物)
     */
    @ApiModelProperty(value = " 综合利用量(一般固体废物)")

    @TableField("solid_use")
    private String solidUse;
    /**
     * 市政处理量(一般固体废物)
     */
    @ApiModelProperty(value = " 市政处理量(一般固体废物)")

    @TableField("solid_municipal")
    private String solidMunicipal;
    /**
     * 一般固体废物处理量(一般固体废物)
     */
    @ApiModelProperty(value = " 一般固体废物处理量(一般固体废物)")

    @TableField("solid_dispose")
    private String solidDispose;
    /**
     * 一般固体废物综合利用率(一般固体废物)
     */
    @ApiModelProperty(value = " 一般固体废物综合利用率(一般固体废物)")

    @TableField("solid_ratio")
    private String solidRatio;
    /**
     * 危险废物产生量(危险废物)
     */
    @ApiModelProperty(value = "  危险废物产生量(危险废物)")

    @TableField("risk_produce")
    private String riskProduce;
    /**
     * 危险废物处置量(危险废物)
     */
    @ApiModelProperty(value = "  危险废物处置量(危险废物)")

    @TableField("risk_dispose")
    private String riskDispose;
    /**
     * 危险废物处置率(危险废物)
     */
    @ApiModelProperty(value = "  危险废物处置率(危险废物)")

    @TableField("risk_ratio")
    private String riskRatio;
    /**
     * 节能投入(节能环保投入)
     */
    @ApiModelProperty(value = "  节能投入(节能环保投入)")

    @TableField("energy_put")
    private String energyPut;
    /**
     * 环保投入(节能环保投入)
     */
    @ApiModelProperty(value = "  环保投入(节能环保投入)")

    @TableField("recycle_put")
    private String recyclePut;
    /**
     * 上报状态 1 已上报 2 逾期上报 3 未上报
     */
    @ApiModelProperty(value = "上报状态 1 已上报 2 逾期上报 3 未上报")

    @TableField("appear_status")
    private String appearStatus;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 审核意见意见
     */
    @ApiModelProperty(value = "审核意见意见")

    @TableField("reject_opinion")
    private String rejectOpinion;

    /**
     * 流程实例id
     */
    @ApiModelProperty(value = "流程实例id")

    @TableField("process_id")
    private String processId;

    /**
     * 营业收入
     */
  @ApiModelProperty(value = "营业收入")
  @TableField("operating_income")
  private String operatingIncome;

    /**
     * 营业收入
     */
    @ApiModelProperty(value = "区域公司id")
    @TableField("regional_org_id")
    private String regionalOrgId;

    /**
     * 营业收入
     */
    @ApiModelProperty(value = "大区名称")
    @TableField("regional_org_name")
    private String regionalOrgName;

    @ApiModelProperty(value = "businessDepartmentName")
    @TableField(exist = false)
    private String businessDepartmentName;


    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String ORG_NAME = "org_name";
    public static final String MONTH = "month";
    public static final String ENERGY_COAL = "energy_coal";
    public static final String ENERGY_POWER = "energy_power";
    public static final String ENERGY_GASOLINE = "energy_gasoline";
    public static final String ENERGY_DERV = "energy_derv";
    public static final String ENERGY_FUEL = "energy_fuel";
    public static final String ENERGY_NATURAL = "energy_natural";
    public static final String ENERGY_HEATING = "energy_heating";
    public static final String ENERGY_OTHER = "energy_other";
    public static final String ENERGY_SYNTHESIZE = "energy_synthesize";
    public static final String WATER_NEW = "water_new";
    public static final String WATER_REPETITION = "water_repetition";
    public static final String WATER_RATE = "water_rate";
    public static final String W_POLLUTANT_O_DISCHARGE = "w_pollutant_o_discharge";
    public static final String W_POLLUTANT_O_COD = "w_pollutant_o_cod";
    public static final String W_POLLUTANT_O_NH3N = "w_pollutant_o_NH3N";
    public static final String W_POLLUTANT_I_DISCHARGE = "w_pollutant_i_discharge";
    public static final String W_POLLUTANT_I_COD = "w_pollutant_i_cod";
    public static final String W_POLLUTANT_I_NH3N = "w_pollutant_i_NH3N";
    public static final String W_POLLUTANT_THIRD_DISCHARGE = "w_pollutant_third_discharge";
    public static final String W_POLLUTANT_THIRD_COD = "w_pollutant_third_cod";
    public static final String W_POLLUTANT_THIRD_NH3N = "w_pollutant_third_NH3N";
    public static final String W_POLLUTANT_DISCHARGE_SUM = "w_pollutant_discharge_sum";
    public static final String W_POLLUTANT_COD_SUM = "w_pollutant_cod_sum";
    public static final String W_POLLUTANT_NH3N_SUM = "w_pollutant_NH3N_sum";
    public static final String ATMOSPHERE_POLLUTANT_STACK = "atmosphere_pollutant_stack";
    public static final String ATMOSPHERE_POLLUTANT_SO2 = "atmosphere_pollutant_so2";
    public static final String ATMOSPHERE_POLLUTANT_NH3N = "atmosphere_pollutant_NH3n";
    public static final String ATMOSPHERE_POLLUTANT_NH3N_ORGANIC = "atmosphere_pollutant_NH3n_organic";
    public static final String ATMOSPHERE_POLLUTANT_NH3N_CO2 = "atmosphere_pollutant_NH3n_co2";
    public static final String ATMOSPHERE_POLLUTANT_NH3N_COUNT = "atmosphere_pollutant_NH3n_count";
    public static final String SOLID_SLAG = "solid_slag";
    public static final String SOLID_SIEVE = "solid_sieve";
    public static final String SOLID_OTHER = "solid_other";
    public static final String SOLID_PRODUCE = "solid_produce";
    public static final String SOLID_USE = "solid_use";
    public static final String SOLID_MUNICIPAL = "solid_municipal";
    public static final String SOLID_DISPOSE = "solid_dispose";
    public static final String SOLID_RATIO = "solid_ratio";
    public static final String RISK_PRODUCE = "risk_produce";
    public static final String RISK_DISPOSE = "risk_dispose";
    public static final String RISK_RATIO = "risk_ratio";
    public static final String ENERGY_PUT = "energy_put";
    public static final String RECYCLE_PUT = "recycle_put";
    public static final String APPEAR_STATUS = "appear_status";
    public static final String PROCESS_STATUS = "process_status";
    public static final String REJECT_OPINION = "reject_opinion";
    public static final String PROCESS_ID = "process_id";

}
