package com.testor.module.hazard.model.domain;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 考试管理—安全培训教育补考表对象 t_train_examination_manage_retake
 *
 * @author testor-framework
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_examination_manage_retake")
@ApiModel(value = "TrainExaminationManageRetake对象", description = "考试管理—安全培训教育补考表")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TrainExaminationManageRetake extends SuperModel {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 补考开始时间
     */
    @ApiModelProperty(value = "补考开始时间")
    @TableField("exam_start_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examStartTime;

    /**
     * 补考结束时间
     */
    @ApiModelProperty(value = "补考结束时间")
    @TableField("exam_end_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examEndTime;

    /**
     * 考试管理—安全培训教育id
     */
    @ApiModelProperty(value = "考试管理—安全培训教育id")
    @TableField("train_examination_manage_id")
    private String trainExaminationManageId;

    /**
     * 考试时长
     */
    @ApiModelProperty(value = "考试时长")
    @TableField("exam_duration")
    private String examDuration;

    /**
     * 考试名称
     */
    @ApiModelProperty(value = "考试名称")
    @TableField("exam_name")
    private String examName;

    /**
     * 及格分数
     */
    @ApiModelProperty(value = "及格分数")
    @TableField("pass_score")
    private Integer passScore;

    // 以下字段继承自SuperModel，无需重复定义
    // status, create_by, create_date, update_by, update_date

    public static final String ID = "id";
    public static final String EXAM_START_TIME = "exam_start_time";
    public static final String EXAM_END_TIME = "exam_end_time";
    public static final String TRAIN_EXAMINATION_MANAGE_ID = "train_examination_manage_id";
    public static final String EXAM_DURATION = "exam_duration";
    public static final String EXAM_NAME = "exam_name";
    public static final String PASS_SCORE = "pass_score";
}